/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public final class RemappingStats {
    private final Map<Key, Integer> COUNTS = Collections.synchronizedMap(new EnumMap(Key.class));

    public int getScripts() {
        return this.COUNTS.getOrDefault((Object)Key.SCRIPT, 0);
    }

    public int getObjectVariables() {
        return this.COUNTS.getOrDefault((Object)Key.OBJECT_VARIABLE, 0);
    }

    public int getAutovars() {
        return this.COUNTS.getOrDefault((Object)Key.AUTOVAR_VARIABLE, 0);
    }

    public int getConditionals() {
        return this.COUNTS.getOrDefault((Object)Key.CONDITIONAL_VARIABLE, 0);
    }

    public int getFunctions() {
        return this.COUNTS.getOrDefault((Object)Key.FUNCTIONS, 0);
    }

    public int getLocalVariables() {
        return this.COUNTS.getOrDefault((Object)Key.LOCAL_VARIABLE, 0);
    }

    public int getParameters() {
        return this.COUNTS.getOrDefault((Object)Key.PARAMETERS, 0);
    }

    public int getDocStrings() {
        return this.COUNTS.getOrDefault((Object)Key.DOCSTRING, 0);
    }

    public void incScripts() {
        int val = this.COUNTS.getOrDefault((Object)Key.SCRIPT, 0);
        this.COUNTS.put(Key.SCRIPT, ++val);
    }

    public void incObjectVariables() {
        int val = this.COUNTS.getOrDefault((Object)Key.OBJECT_VARIABLE, 0);
        this.COUNTS.put(Key.OBJECT_VARIABLE, ++val);
    }

    public void incAutoVariables() {
        int val = this.COUNTS.getOrDefault((Object)Key.AUTOVAR_VARIABLE, 0);
        this.COUNTS.put(Key.AUTOVAR_VARIABLE, ++val);
    }

    public void incConditionals() {
        int val = this.COUNTS.getOrDefault((Object)Key.CONDITIONAL_VARIABLE, 0);
        this.COUNTS.put(Key.CONDITIONAL_VARIABLE, ++val);
    }

    public void incFunctions() {
        int val = this.COUNTS.getOrDefault((Object)Key.FUNCTIONS, 0);
        this.COUNTS.put(Key.FUNCTIONS, ++val);
    }

    public void incLocalVariables() {
        int val = this.COUNTS.getOrDefault((Object)Key.LOCAL_VARIABLE, 0);
        this.COUNTS.put(Key.LOCAL_VARIABLE, ++val);
    }

    public void incParameters() {
        int val = this.COUNTS.getOrDefault((Object)Key.PARAMETERS, 0);
        this.COUNTS.put(Key.PARAMETERS, ++val);
    }

    public void incDocStrings() {
        int val = this.COUNTS.getOrDefault((Object)Key.DOCSTRING, 0);
        this.COUNTS.put(Key.DOCSTRING, ++val);
    }

    public String toString() {
        StringBuilder BUF = new StringBuilder();
        BUF.append(String.format("Processed %d scripts.\n", this.getScripts()));
        BUF.append(String.format("Renamed %d object variables.\n", this.getObjectVariables() - this.getConditionals()));
        BUF.append(String.format("%d of them were property autovariables.\n", this.getAutovars() - this.getConditionals()));
        BUF.append(String.format("Skipped %d conditional autovariables.\n", this.getConditionals()));
        BUF.append(String.format("Processed %d functions.\n", this.getFunctions()));
        BUF.append(String.format("Renamed %d function local variables.\n", this.getLocalVariables()));
        BUF.append(String.format("Renamed %d function parameters.\n", this.getParameters()));
        BUF.append(String.format("Stripped %d docstrings.\n", this.getDocStrings()));
        return BUF.toString();
    }

    private static enum Key {
        SCRIPT,
        OBJECT_VARIABLE,
        AUTOVAR_VARIABLE,
        CONDITIONAL_VARIABLE,
        FUNCTIONS,
        LOCAL_VARIABLE,
        PARAMETERS,
        DOCSTRING;

    }
}

