/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import restringer.pex.StringTable;

final class VariableType {
    public StringTable.TString name;
    public final StringTable.TString TYPE;
    static final Pattern TEMP_PATTERN = Pattern.compile("^::.+$");

    VariableType(DataInput input, StringTable strings) throws IOException {
        this.name = strings.read(input);
        this.TYPE = strings.read(input);
    }

    void write(DataOutput output) throws IOException {
        this.name.write(output);
        this.TYPE.write(output);
    }

    public int calculateSize() {
        return 4;
    }

    public boolean isTemp() {
        return TEMP_PATTERN.asPredicate().test(this.name.toString());
    }

    public void collectStrings(Set<StringTable.TString> strings) {
        strings.add(this.name);
        strings.add(this.TYPE);
    }

    public String toString() {
        String FORMAT = "%s %s";
        return String.format("%s %s", this.TYPE, this.name);
    }
}

