/*
 * Copyright 2016 Mark.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer;

/**
 * A counter that registers hits and misses.
 * 
 * @author Mark Fairchild
 * @version 2016/09/08
 */
final public class BinomialCounter {
    
    public BinomialCounter() {
        this.count = 0;
        this.total = 0;
    }
    
    public void hit() {
        this.count++;
        this.total++;
    }
    
    public void miss() {
        this.total++;
    }
    
    public int getHits() {
        return this.count;
    }
    
    public int getMisses() {
        return this.total - this.count;
    }
    
    public int getTotal() {
        return this.total;
    }
    
    public double getMean() {
        return (double) this.count / (double) this.total;
    }
    
    @Override
    public String toString() {
        return this.count + "/" + this.total;
    }
    
    private int count, total;
}
