/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer;

import java.io.IOException;
import java.util.logging.*;
import org.apache.commons.cli.CommandLine;
import restringer.gui.ModChooser;

/**
 * Entry class for ReStringer.
 *
 * @author Mark Fairchild
 * @version 2016/07/03
 */
final public class ReStringer {

    /**
     * @param line The parsed command line.
     */
    public static void execute(CommandLine line) {
        try {
            LOG.getParent().addHandler(new FileHandler("ReStringer.%g.log.xml", 1 << 20, 1));
        } catch (IOException ex) {
            LOG.warning("Couldn't create log file.");
            LOG.warning(ex.toString());
        }

        LOG.getParent().getHandlers()[0].setFormatter(new java.util.logging.Formatter() {
            @Override
            public String format(LogRecord record) {
                final java.util.logging.Level LEVEL = record.getLevel();
                final String MSG = record.getMessage();
                final String SRC = record.getSourceClassName() + "." + record.getSourceMethodName();
                return String.format("%s: %s (in %s)\n", LEVEL, MSG, SRC);
            }
        });

        LOG.setLevel(Level.FINE);
        LOG.getParent().getHandlers()[0].setLevel(Level.FINE);

        try {
            javax.swing.UIManager.setLookAndFeel(javax.swing.UIManager.getSystemLookAndFeelClassName());
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            LOG.log(java.util.logging.Level.SEVERE, null, ex);
        }

        try {
            java.awt.EventQueue.invokeLater(() -> new ModChooser().setVisible(true));
        } catch (Exception ex) {
            LOG.log(java.util.logging.Level.SEVERE, null, ex);
            ex.printStackTrace(System.out);
        }
    }

    static final private Logger LOG = Logger.getLogger(ReStringer.class.getCanonicalName());

}
