/*
 * Copyright 2016 Mark Fairchild
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.bsa;

import restringer.LittleEndianRAF;
import java.io.IOException;

/**
 * Describes a BSA file record.
 *
 * @author Mark Fairchild
 * @version 2016/04/28
 */
class FileRecord {

    /**
     * Creates a new <code>FileRecord</code> by reading from a
     * <code>LittleEndianDataInput</code>. The name field will be set to null.
     *
     * @param input The file from which to readFully.
     * @param header
     * @throws IOException
     *
     */
    public FileRecord(LittleEndianRAF input, BSAHeader header) throws IOException {
        this.NAMEHASH = input.readLong();

        int size = input.readInt();
        final int BIT30 = 1 << 30;
        boolean compressToggle = ((size & BIT30) != 0);

        this.SIZE = size & ~BIT30;
        this.OFFSET = input.readInt();
        this.COMPRESSED = header.isCompressedArchive() ^ compressToggle;
        this.name = null;
    }

    @Override
    public String toString() {
        if (this.name == null) {
            return String.format("%d bytes at offset %d", this.SIZE, this.OFFSET);
        } else {
            return this.name;
        }
    }

    final public long NAMEHASH;
    final public int SIZE;
    final public int OFFSET;
    final public boolean COMPRESSED;
    public String name;
}
