/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.bsa;

import restringer.LittleEndianRAF;
import java.io.IOException;

/**
 * Describes a BSA folder record.
 *
 * @author Mark Fairchild
 * @version 2016/04/27
 */
final class FolderRecord {

    /**
     * Creates a new <code>BSAFolder</code> by reading from a
     * <code>LittleEndianDataInput</code>.
     *
     * @param input The file from which to readFully.
     * @param header
     * @throws IOException
     *
     */
    public FolderRecord(LittleEndianRAF input, BSAHeader header) throws IOException {
        this.NAMEHASH = input.readLong();
        this.COUNT = input.readInt();
        this.OFFSET = input.readInt();

        long position = input.getFilePointer();
        assert position < (1 << 31) - 1;
        
        input.seek(this.OFFSET - header.TOTAL_FILENAME_LENGTH);
        this.NAME = input.readBZString();
        input.seek(position);
    }

    @Override
    public String toString() {
        return this.NAME;
    }

    final public long NAMEHASH;
    final public int COUNT;
    final public int OFFSET;
    final public String NAME;
}
