/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.ess.papyrus;

import restringer.ess.Element;
import restringer.ess.ESS;

/**
 * Designates an element of the papyrus section of a savegame.
 *
 * @author Mark Fairchild
 * @version 2016/06/11
 */
public interface PapyrusElement extends restringer.ess.Element {

    /**
     * Resolves references using the full savefile.
     *
     * @param ess The full savefile.
     * @param owner The owner of the element, or null if it is not owned.
     */
    abstract public void resolveRefs(ESS ess, Element owner);

    /**
     * Assign names to all embedded refids.
     *
     * @param names The map of IDs to names.
     * @param strings The stringtable.
     */
    abstract public void addNames(restringer.esp.ESPIDMap names, restringer.esp.StringTable strings);

}
