/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.gui;

import java.util.Objects;
import restringer.ess.papyrus.*;


/**
 * A table model for papyrus script instances.
 * 
 * @author Mark Fairchild
 * @version 2016/06/15
 */
public class ArrayTableModel extends VariableTableModel {

    public ArrayTableModel(ArrayInfo array) {
        this.ARRAY = Objects.requireNonNull(array);
    }

    @Override
    protected int getNumVariables() {
        return this.ARRAY.getData().getMembers().size();
    }

    @Override
    protected Variable getVariable(int index) {
        return this.ARRAY.getData().getMembers().get(index);
    }

    @Override
    protected MemberData getMemberData(int index) {
        return null;
    }

    @Override
    protected void setVariable(int index, Variable newVar) {
        this.ARRAY.getData().getMembers().set(index, newVar);
    }

    @Override
    protected boolean supportsMemberData() {
        return false;
    }

    final private ArrayInfo ARRAY;

}
