/*
 * Copyright 2016 Mark.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import javafx.application.Platform;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

/**
 *
 * @author Mark
 */
public class ModalProgressDialog extends JDialog {

    public ModalProgressDialog(Frame owner, String title, Runnable task) {
        super(owner, title, ModalityType.APPLICATION_MODAL);
        this.TOPPANEL = new JPanel();
        this.BOTTOMPANEL = new JPanel();
        this.LABEL = new JLabel(java.util.ResourceBundle.getBundle("restringer/gui/General").getString("PLEASE WAIT."));
        this.BAR = new JProgressBar();
        this.initComponents(task);
    }

    /**
     * Initialize the swing and AWT components.
     *
     */
    private void initComponents(Runnable task) {
        this.setPreferredSize(new Dimension(420, 100));
        this.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        this.BAR.setPreferredSize(new Dimension(400, 30));
        this.TOPPANEL.add(this.LABEL);
        this.BOTTOMPANEL.add(this.BAR);

        this.setLayout(new BorderLayout());
        this.add(this.TOPPANEL, BorderLayout.PAGE_START);
        this.add(this.BOTTOMPANEL, BorderLayout.PAGE_END);

        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());

        this.addWindowListener(new WindowAdapter() {
            @Override
            public void windowOpened(WindowEvent e) {
                Objects.requireNonNull(task);
                Platform.runLater(() -> {
                    task.run();
                    setVisible(false);
                });
            }

            @Override
            public void windowClosing(WindowEvent e) {

            }

            @Override
            public void windowClosed(WindowEvent e) {
                dispose();
            }
        });
    }

    final private JPanel TOPPANEL;
    final private JPanel BOTTOMPANEL;
    final private JLabel LABEL;
    final private JProgressBar BAR;
}
