/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.gui;

import java.awt.Font;
import javax.swing.JTextArea;
import restringer.Mod;
import restringer.Profile;

/**
 * Shows info about a mod or mod-set.
 *
 * @author Mark Fairchild
 * @version 2016/05/23
 */
public class ProfileInfoPanel extends JTextArea {

    /**
     * Creates a new ModInfoPanel.
     */
    public ProfileInfoPanel() {
        this.profile = null;
        Font font = new Font(Font.MONOSPACED, 0, 12);
        super.setFont(font);
        //super.setWrapStyleWord(true);
        //super.setLineWrap(true);
    }

    /**
     *
     * @param newProfile
     */
    public void setProfile(Profile newProfile) {
        this.profile = newProfile;
        this.update();
    }

    synchronized public void update() {
        this.setText("");
        
        if (null == this.profile) {
            return;
        }

        
        Mod.Analysis analysis = this.profile.getFastAnalysis();
        String time = (this.profile.getBuildTime() == null ? "never" : this.profile.getBuildTime().toString());        
        java.io.File path = this.profile.getOutputDirectory();
        
        this.append(String.format("Last time processed  : %s\n", time));
        this.append(String.format("Output directory     : %s\n", (path == null ? "(not set)" : path.getPath())));
        this.append(String.format("Mods included        : %d / %d\n", this.profile.getCheckmarkedMods().size(), this.profile.getMods().size()));
        this.append(String.format("Total scripts        : %d scripts\n", analysis.NUMSCRIPTS));
        this.append(String.format("Total readable data  : %1.1f mb\n", analysis.NUMBYTES / 1048576.0));
        this.append(String.format("Remappable variables : %d strings\n", analysis.NUMSTRINGS));
    }

    private Profile profile;

}
