/*
 * Copyright 2016 Mark Fairchild.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package restringer.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import restringer.ess.ESS;

/**
 *
 * @author Mark Fairchild
 */
public class Saver extends SwingWorker<ESS, Double> {

    /**
     * 
     * @param window
     * @param saveFile
     * @param save
     * @param promptToOpen
     * @param quitAfter 
     */
    public Saver(SaveWindow window, File saveFile, ESS save, boolean promptToOpen, boolean quitAfter) {
        this.WINDOW = Objects.requireNonNull(window, "The window field must not be null.");
        this.SAVEFILE = Objects.requireNonNull(saveFile, "The saveFile field must not be null.");
        this.SAVE = Objects.requireNonNull(save, "The save field must not be null.");
        this.PROMPT = promptToOpen;
        this.QUIT = quitAfter;
    }

    /**
     * 
     * @return
     * @throws Exception 
     */
    @Override
    protected ESS doInBackground() throws Exception {
        if (!Configurator.validateNewSavegame(this.SAVEFILE)) {
            return null;
        }

        final ProgressModel MODEL = new ProgressModel();

        ProgressIndicator.startWaitCursor(this.WINDOW.getRootPane());
        this.WINDOW.addWindowListener(this.LISTENER);
        this.WINDOW.startProgressBar(MODEL);

        try {
            LOG.info("================");
            LOG.info(String.format("Writing to savegame file \"%s\".", this.SAVEFILE));

            ESS.writeESS(this.SAVE, this.SAVEFILE, MODEL);
            JOptionPane.showMessageDialog(this.WINDOW, "The savefile was successfully written.", "Save Written", JOptionPane.INFORMATION_MESSAGE);
            this.WINDOW.clearModified();

            //this.WINDOW.clearESS();
            this.WINDOW.setESS(this.SAVEFILE, this.SAVE);

                    if (this.PROMPT) {
                this.WINDOW.open(false);
            } else if (this.QUIT) {
                this.WINDOW.exit();
            } else {
                
            }
            return this.SAVE;

        } catch (IOException ex) {
            final String MSG = String.format("Error while writing file \"%s\".\n%s", this.SAVEFILE.getName(), ex.getMessage());
            LOG.severe(MSG);
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.WINDOW, MSG, "Write Error", JOptionPane.ERROR_MESSAGE);
            return null;

        } catch (Exception | Error ex) {
            final String MSG = String.format("Error while writing file \"%s\".\n%s", this.SAVEFILE.getName(), ex.getMessage());
            LOG.severe(MSG);
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.WINDOW, MSG, "Write Error", JOptionPane.ERROR_MESSAGE);
            return null;

        } finally {
            this.WINDOW.removeWindowListener(this.LISTENER);
            ProgressIndicator.stopWaitCursor(this.WINDOW.getRootPane());
            this.WINDOW.clearProgressBar();
        }
    }

    final private File SAVEFILE;
    final private SaveWindow WINDOW;
    final private ESS SAVE;
    final private boolean PROMPT, QUIT;
    static final private Logger LOG = Logger.getLogger(Saver.class.getCanonicalName());

    final private WindowAdapter LISTENER = new WindowAdapter() {
        @Override
        public void windowClosing(WindowEvent e) {
            if (!isDone()) {
                cancel(true);
            }
        }
    };
}
