PrefabFiles = {
	"deep_freezer",
	"complex_machinery",
}

Assets = 
{
	Asset("ATLAS", "images/inventoryimages/deep_freezer.xml"),
	Asset( "IMAGE", "minimap/deep_freezer.tex" ),
	Asset( "ATLAS", "minimap/deep_freezer.xml" ),
	Asset("ATLAS", "images/inventoryimages/frozen.xml"),
}
AddMinimapAtlas("minimap/deep_freezer.xml")

TUNING.LCH_THAW_TIME = TUNING.PERISH_TWO_DAY
GLOBAL.STRINGS.UI.HUD.LHC_FROZENFOOD = "Frozen"
GLOBAL.STRINGS.MODS = GLOBAL.STRINGS.MODS or {}
GLOBAL.STRINGS.MODS.LHC = GLOBAL.STRINGS.MODS.LHC or {}
GLOBAL.STRINGS.MODS.LHC.PREPEND = "lhc_frozen_"

local function funcConcat(prefunc, origfunc, postfunc)
	return function(...)
		local args = {...}
		args.old = {}
		if prefunc then
			prefunc(args)
		end
		if origfunc then
			args.ret = origfunc(GLOBAL.unpack(args))
		end
		if postfunc then
			postfunc(args)
		end
		return args.ret
	end
end

local function SpawnWrapPre(args)
	local nBeg, nEnd = args[1]:find('.*'..GLOBAL.STRINGS.MODS.LHC.PREPEND)
	if (nEnd and args[1]:find(GLOBAL.STRINGS.MODS.LHC.PREPEND)) then
		args.old[1] = args[1]
		args[1] = args[1]:sub(nEnd + 1)
	end
end
local function SpawnWrapPost(args)
	if (args.ret and args.ret.components.perishable and args.ret.components.edible and not args.ret.prefab:find("dried") and not args.ret.prefab:find("cooked") and not args.ret.entity:HasTag("preparedfood") and not args.ret.components.freezablefood) then
		args.ret:AddComponent("freezablefood")
	end
	if (args.old[1] and args.ret) then
		args.ret.components.perishable.GetAdjective = nil
		args.ret.components.freezablefood:FreezeItem(false)
	end
end
GLOBAL.SpawnPrefab = funcConcat(SpawnWrapPre, GLOBAL.SpawnPrefab, SpawnWrapPost)

GLOBAL.STRINGS.NAMES.DEEP_FREEZER = "Deep-Freezer" 
GLOBAL.STRINGS.RECIPE_DESC.DEEP_FREEZER = "Deep-freeze your stuff!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.DEEP_FREEZER = "Brr!"
GLOBAL.STRINGS.NAMES.COMPLEX_MACHINERY = "Complex Machinery"
GLOBAL.STRINGS.RECIPE_DESC.COMPLEX_MACHINERY = "Add some complex to your machinery!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.COMPLEX_MACHINERY = "Seems complex!"

local deep_freezer = GLOBAL.Recipe("deep_freezer",{GLOBAL.Ingredient("cutstone", 5), GLOBAL.Ingredient("complex_machinery", 2, "images/inventoryimages/complex_machinery.xml"), GLOBAL.Ingredient("boards", 5) },                     
GLOBAL.RECIPETABS.FARM, GLOBAL.TECH.SCIENCE_TWO, "deep_freezer_placer" ) 
deep_freezer.atlas = "images/inventoryimages/deep_freezer.xml"

local complex_machinery = GLOBAL.Recipe("complex_machinery",{GLOBAL.Ingredient("gears",1), GLOBAL.Ingredient("goldnugget",1)},GLOBAL.RECIPETABS.REFINE, GLOBAL.TECH.SCIENCE_TWO)
complex_machinery.atlas = "images/inventoryimages/complex_machinery.xml"

local function SlotTintPostInit(self, num, atlas, bgim, owner, container)
	if container.slotbgimagetint then
		self.bgimage:SetTint(GLOBAL.unpack(container.slotbgimagetint))
    end
end
AddClassPostConstruct("widgets/invslot", SlotTintPostInit)

local Image = GLOBAL.require "widgets/image"
local function TileThawPostInit(self, invitem)
	self.thaw_bg = self:AddChild(Image())
	self.thaw_bg:SetTexture("images/inventoryimages/frozen.xml", "frozen.tex")
	self.thaw_bg:Hide()
	self.thaw_bg:SetClickable(false)
	self.thaw_basescale = 1
	if invitem.components.freezablefood and invitem.components.freezablefood:IsFrozen() then
		self.thaw_bg:Show()
	end
end
AddClassPostConstruct("widgets/itemtile", TileThawPostInit)

local function IceBoxPostInit(inst)
	inst.components.container.itemtestfn = funcConcat(nil, inst.components.container.itemtestfn, function(args) args.ret = (args.ret or args[2].components.freezablefood) and true end)
end
AddPrefabPostInit("icebox", IceBoxPostInit)