local assets = {
	Asset("ANIM", "anim/complex_machinery.zip"),
	Asset("ATLAS", "images/inventoryimages/complex_machinery.xml"),
    Asset("IMAGE", "images/inventoryimages/complex_machinery.tex"),
}

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()        
    MakeInventoryPhysics(inst)
    
    anim:SetBank("complex_machinery")
    anim:SetBuild("complex_machinery")
    anim:PlayAnimation("idle")

	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "complex_machinery"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/complex_machinery.xml"
    
    return inst
end

return Prefab( "common/inventory/complex_machinery", fn, assets) 