require "prefabutil"

local assets = {
	Asset("ANIM", "anim/deep_freezer.zip"),
	Asset("ANIM", "anim/ui_chest_3x3.zip"),
}

local function onopen(inst)
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")		
	inst.AnimState:PlayAnimation("open")
	local thawList = inst.components.container:FindItems(function(item) return item.components.perishable ~= nil and item.components.freezablefood and item.components.freezablefood:IsFrozen() end)
	for i =1,#thawList do
		thawList[i].components.perishable:SetPerishTime(TUNING.LCH_THAW_TIME)
		thawList[i].components.perishable:StartPerishing()
	end
end 

local function onclose(inst) 
	inst.AnimState:PlayAnimation("closed")
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")		
	local freezeList = inst.components.container:FindItems(function(item) return item.components.freezablefood ~= nil and item.prefab ~= "ice" end)
	for i=1,#freezeList do
		freezeList[i].components.freezablefood:FreezeItem(true) --everything freezes when you close the lid
	end
	for i=inst.components.container:GetNumSlots(),1,-1 do
		inst.components.container:GiveItem(inst.components.container:RemoveItemBySlot(i)) --exploits GiveItem logic to effectively recombine all stackable items in inventory
	end
end 

local function onhammered(inst, worker)
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_metal")
	inst.components.container:DropEverything()
	inst.components.lootdropper:DropLoot()
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("closed", false)
	inst.components.container:DropEverything()
	inst.components.container:Close()
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("closed", false)
end

local slotpos = {}

for y = 2, 0, -1 do
	for x = 0, 2 do
		table.insert(slotpos, Vector3(80*x-80*2+80, 80*y-80*2+80,0))
	end
end

local function itemtest(inst, item, slot)
	return item.components.freezablefood and (item.components.perishable and item.components.perishable:IsFresh() or item.components.freezablefood:IsFrozen()) and true --don't accept stale stuff, unless it's frozen (i.e. almost thawed)
end
		
local function fn(Sim)
	local inst = CreateEntity()
	
	inst:AddTag("fridge")
    inst:AddTag("structure")
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "deep_freezer.tex" )
	
    inst.AnimState:SetBank("deep_freezer")
    inst.AnimState:SetBuild("deep_freezer")
    inst.AnimState:PlayAnimation("closed")

    inst:AddComponent("inspectable")
	
    inst:AddComponent("container")
    inst.components.container.slotbgimagetint = {.42,.80,1,1} --r,g,b,alpha values to handle slot tinting
    inst.components.container.itemtestfn = itemtest
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.onopenfn = onopen
    inst.components.container.onclosefn = onclose
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetanimbank = "ui_chest_3x3"
    inst.components.container.widgetanimbuild = "ui_chest_3x3"
    inst.components.container.widgetpos = Vector3(200,200,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160 
	
    inst:AddComponent("lootdropper")

    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(3)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit) 
	
	MakeSnowCovered(inst, .01)	
	inst:ListenForEvent("onbuilt", onbuilt)
    return inst
end

return Prefab( "common/deep_freezer", fn, assets),
		MakePlacer("common/deep_freezer_placer", "deep_freezer", "deep_freezer", "closed") 

