require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/christmas_tree.zip"),
}

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PushAnimation("christmas")
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("christmas")
end

local function fn(Sim)
	local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		inst.entity:AddLight()

		local minimap = inst.entity:AddMiniMapEntity()
		minimap:SetIcon("christmas_tree.tex")

		inst.AnimState:SetBank("christmas_tree")
		inst.AnimState:SetBuild("christmas_tree")
		inst.AnimState:PlayAnimation("christmas", true)

		inst.Light:Enable(true)
		--inst.Light:SetIntensity(.75)
		inst.Light:SetIntensity(0.85) --сглаживание
		--inst.Light:SetColour(252/255,251/255,237/255)
		inst.Light:SetColour(248/255,255/255,255/255)
		inst.Light:SetFalloff( 0.6 ) --0.6 
		inst.Light:SetRadius(3.5)

		inst:AddComponent("sanityaura")
		inst.components.sanityaura.aura = TUNING.SANITYAURA_SMALL
		
		MakeObstaclePhysics(inst, 0.9)

		inst:AddComponent("inspectable")
		inst:AddComponent("lootdropper")
		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
		inst.components.workable:SetWorkLeft(3)
		inst.components.workable:SetOnFinishCallback(onhammered)
		inst.components.workable:SetOnWorkCallback(onhit)

	return inst
end

return Prefab( "common/christmas_tree", fn, assets),
	MakePlacer("common/christmas_tree_placer", "christmas_tree", "christmas_tree", "christmas") 

