local BioInd = require('__Bio_Industries__/common')('Bio_Industries')
log("Entered fixed migration script!")
------------------------------------------------------------------------------------
-- In 0.18.11, loading a saved game could have resulted in a crash because a
-- complete table (instead of individual entries) was removed. However, if
-- the complete table *was* deleted, the game *must* have crashed and the original
-- tables couldn't have been overwritten in a new saved game. So, we can presume
-- all tables still exist in the state of pre 0.18.11 and just run the (fixed)
-- migration script from 0.18.11 again.
------------------------------------------------------------------------------------

local pole_name = "bi-hidden-power-pole"
local lamp_name = "bi-bio-farm-light"

local pole_count = 0
local lamp_count = 0

-- Restoring hidden power pole for solar boilers
if global.bi_solar_boiler_table then
  for index, solar_boiler in pairs(global.bi_solar_boiler_table) do
    -- Remove invalid solar boilers from list
    if not solar_boiler.base.valid then
      BioInd.writeDebug("Removing invalid solar boiler " .. tostring(index) .. " from global list.")
      if solar_boiler.boiler.valid then
        solar_boiler.boiler.destroy()
      end
      if solar_boiler.pole.valid then
        solar_boiler.pole.destroy()
      end
      global.bi_solar_boiler_table[index] = nil

    -- Restore hidden power pole if necessary
    elseif not solar_boiler.pole.valid then
      BioInd.writeDebug("Creating new hidden power pole for solar boiler " .. tostring(index) .. ".")
      global.bi_solar_boiler_table[index].pole = solar_boiler.base.surface.create_entity({
        name = pole_name,
        position = solar_boiler.base.position,
        direction = solar_boiler.base.direction,
        force = solar_boiler.base.force
      })
      pole_count = pole_count + 1
    end
  end
  if pole_count > 0 then
    log("Restored " .. tostring(pole_count) .. " hidden power poles for solar boilers.")
    game.print("[Bio Industries] Restored " .. tostring(pole_count) .. " hidden power poles for solar boilers.")
  end
end

-- Restoring hidden power pole for solar farms
if global.bi_solar_farm_table then
  pole_count = 0

  for index, solar_farm in pairs(global.bi_solar_farm_table) do
    -- Remove invalid solar boilers from list
    if not solar_farm.base.valid then
      BioInd.writeDebug("Removing invalid solar farm " .. tostring(index) .. " from global list.")
      if solar_farm.pole.valid then
        solar_farm.pole.destroy()
      end
      global.bi_solar_farm_table[index] = nil

    -- Restore hidden power pole if necessary
    elseif not solar_farm.pole.valid then
      BioInd.writeDebug("Creating new hidden power pole for solar farm " .. tostring(index) .. ".")
      --~ local new_pole = solar_farm.base.surface.create_entity({
      global.bi_solar_farm_table[index].pole = solar_farm.base.surface.create_entity({
        name = pole_name,
        position = solar_farm.base.position,
        direction = solar_farm.base.direction,
        force = solar_farm.base.force
      })
      pole_count = pole_count + 1
    end
  end
  if pole_count > 0 then
    log("Restored " .. tostring(pole_count) .. " hidden power poles for solar farms.")
    game.print("[Bio Industries] Restored " .. tostring(pole_count) .. " hidden power poles for solar farms.")
  end
end


-- Restoring hidden power pole and hidden lamps for bio farms
if global.bi_bio_farm_table then
  pole_count = 0

  for index, bio_farm in pairs(global.bi_bio_farm_table) do
    -- Remove invalid solar boilers from list
    if not bio_farm.base.valid then
      BioInd.writeDebug("Removing invalid solar farm " .. tostring(index) .. " from global list.")
      if bio_farm.pole.valid then
        bio_farm.pole.destroy()
      end
      if bio_farm.panel.valid then
        bio_farm.panel.destroy()
      end
      if bio_farm.lamp.valid then
        bio_farm.lamp.destroy()
      end
      global.bi_bio_farm_table[index] = nil

    -- Restore hidden entities if necessary
    else
      -- Restore hidden power pole
      if not bio_farm.pole.valid then
        BioInd.writeDebug("Creating new hidden power pole for solar farm " .. tostring(index) .. ".")
        --~ local new_pole = bio_farm.base.surface.create_entity({
        global.bi_bio_farm_table[index].pole = bio_farm.base.surface.create_entity({
          name = pole_name,
          position = bio_farm.base.position,
          direction = bio_farm.base.direction,
          force = bio_farm.base.force
        })
        pole_count = pole_count + 1
      end
      -- Restore hidden lamp
      if not bio_farm.lamp.valid then
        BioInd.writeDebug("Creating new hidden lamp for solar farm " .. tostring(index) .. ".")
        --~ local new_lamp = bio_farm.base.surface.create_entity({
        global.bi_bio_farm_table[index].lamp = bio_farm.base.surface.create_entity({
          name = lamp_name,
          position = bio_farm.base.position,
          force = bio_farm.base.force
        })
        lamp_count = lamp_count + 1
      end
    end
  end
  if pole_count > 0 or lamp_count > 0 then
    log("Restored " .. tostring(pole_count) .. " hidden power poles and " .. tostring(lamp_count) ..
        " hidden lamps for bio farms.")
    game.print("[Bio Industries] Restored " .. tostring(pole_count) .. " hidden power poles and " ..
                tostring(lamp_count) ..  " hidden lamps for bio farms.")
  end
end
