local TUNING = GLOBAL.TUNING
local BOSS_PERIOD = GetModConfigData("boss_period")
local BIOLOGY_PERIOD = GetModConfigData("biology_period")
local ARMOUR_ARMOR = GetModConfigData("armour_armor")

--血量（BOSS）
TUNING.DRAGONFLY_HEALTH = 27500 * GetModConfigData("health_boss")                            --龙蝇
TUNING.BEARGER_HEALTH = 3000 * 2 * GetModConfigData("health_boss")                           --熊大
TUNING.DEERCLOPS_HEALTH = 2000 * 2 * GetModConfigData("health_boss")                         --巨鹿
TUNING.MOOSE_HEALTH = 3000 * 2 * GetModConfigData("health_boss")                             --鹿角鹅
TUNING.MOSSLING_HEALTH = 350 * 1.5 * GetModConfigData("health_boss")                         --小鸭子
TUNING.MINOTAUR_HEALTH = 2500 * 4 * GetModConfigData("health_boss")                          --远古守护者
TUNING.BEEQUEEN_HEALTH = 22500 * GetModConfigData("health_boss")                             --蜂后
TUNING.TOADSTOOL_HEALTH = 52500 * GetModConfigData("health_boss")                            --普通蛤蟆
TUNING.TOADSTOOL_DARK_HEALTH = 99999 * GetModConfigData("health_boss")                       --毒蛤蟆
TUNING.SPIDERQUEEN_HEALTH = 1250 * 2 * GetModConfigData("health_boss")                       --蜘蛛女皇
TUNING.LEIF_HEALTH = 2000 * 1.5 * GetModConfigData("health_boss")                            --树精
TUNING.WARG_HEALTH = 600 * 3 * GetModConfigData("health_boss")                               --座狼
TUNING.SPAT_HEALTH = 800 * GetModConfigData("health_boss")                                   --钢羊
TUNING.WALRUS_HEALTH = 150 * 2 * GetModConfigData("health_boss")                             --海象
--血量（生物）
TUNING.KOALEFANT_HEALTH = 500 * 2 * GetModConfigData("health_biology")                          --大象
TUNING.TALLBIRD_HEALTH = 400 * 2 * GetModConfigData("health_biology")                           --高脚鸟
TUNING.TENTACLE_HEALTH = 500 * GetModConfigData("health_biology")                               --触手
TUNING.MERM_HEALTH = 250 * 2 * GetModConfigData("health_biology")                               --鱼人
TUNING.WORM_HEALTH = 900 * GetModConfigData("health_biology")                                   --蠕虫
TUNING.WEREPIG_HEALTH = 350 * 1.5 * GetModConfigData("health_biology")                          --疯猪
TUNING.SPIDER_HEALTH = 100 * GetModConfigData("health_biology")                                 --小蜘蛛
TUNING.SPIDER_WARRIOR_HEALTH = 200 * 2 * GetModConfigData("health_biology")                     --蜘蛛战士，白蜘蛛
TUNING.SPIDER_HIDER_HEALTH = 150 * 1.5 * GetModConfigData("health_biology")                     --洞穴蜘蛛
TUNING.SPIDER_SPITTER_HEALTH = 175 * 2 * GetModConfigData("health_biology")                     --喷吐蜘蛛
TUNING.HOUND_HEALTH = 150 * GetModConfigData("health_biology")                                  --狗
TUNING.FIREHOUND_HEALTH = 100 * GetModConfigData("health_biology")                              --火狗
TUNING.ICEHOUND_HEALTH = 100 * GetModConfigData("health_biology")                               --冰狗

--伤害（boss）
TUNING.DRAGONFLY_DAMAGE = 150 * GetModConfigData("damage_boss")                              --龙蝇
TUNING.DRAGONFLY_FIRE_DAMAGE = 300 * GetModConfigData("damage_boss")                         --暴怒龙蝇
TUNING.BEARGER_DAMAGE = 200 * GetModConfigData("damage_boss")                                --熊大
TUNING.DEERCLOPS_DAMAGE = 150 * GetModConfigData("damage_boss")                              --巨鹿
TUNING.MOOSE_DAMAGE = 150 * GetModConfigData("damage_boss")                                  --鹿角鹅
TUNING.MINOTAUR_DAMAGE = 100 * GetModConfigData("damage_boss")                               --远古守护者
TUNING.BEEQUEEN_DAMAGE = 120 * GetModConfigData("damage_boss")                               --蜂后
TUNING.SPIDERQUEEN_DAMAGE = 80 * GetModConfigData("damage_boss")                             --蜘蛛女皇
TUNING.LEIF_DAMAGE = 150 * GetModConfigData("damage_boss")                                   --树精
TUNING.WARG_DAMAGE = 50 * GetModConfigData("damage_boss")                                    --座狼
TUNING.SPAT_MELEE_DAMAGE = 60 * GetModConfigData("damage_boss")                              --钢羊
TUNING.WALRUS_DAMAGE = 33 * GetModConfigData("damage_boss")                                  --海象
--伤害（生物）
TUNING.KOALEFANT_DAMAGE = 50 * GetModConfigData("damage_biology")                               --象
TUNING.TALLBIRD_DAMAGE = 50 * GetModConfigData("damage_biology")                                --高脚鸟
TUNING.TENTACLE_DAMAGE = 34 * GetModConfigData("damage_biology")                                --触手
TUNING.MERM_DAMAGE = 30 * GetModConfigData("damage_biology")                                    --鱼人
TUNING.WORM_DAMAGE = 75 * GetModConfigData("damage_biology")                                    --蠕虫
TUNING.WEREPIG_DAMAGE = 40 * GetModConfigData("damage_biology")                                 --疯猪
TUNING.SPIDER_DAMAGE = 20 * GetModConfigData("damage_biology")                                  --小蜘蛛
TUNING.SPIDER_WARRIOR_DAMAGE = 20 * GetModConfigData("damage_biology")                          --蜘蛛战士，白蜘蛛
TUNING.SPIDER_HIDER_DAMAGE = 20 * GetModConfigData("damage_biology")                            --洞穴蜘蛛
TUNING.SPIDER_SPITTER_DAMAGE_MELEE = 20 * GetModConfigData("damage_biology")                    --喷吐蜘蛛近战伤害
TUNING.HOUND_DAMAGE = 20 * GetModConfigData("damage_biology")                                   --狗
TUNING.FIREHOUND_DAMAGE = 30 * GetModConfigData("damage_biology")                               --火狗
TUNING.ICEHOUND_DAMAGE = 30 * GetModConfigData("damage_biology")                                --冰狗

--攻击间隔
if BOSS_PERIOD then                                           --boss
   TUNING.DRAGONFLY_ATTACK_PERIOD = 1                         --龙蝇
   TUNING.DRAGONFLY_FIRE_ATTACK_PERIOD = 1                    --暴怒龙蝇
   TUNING.BEARGER_ATTACK_PERIOD = 1                           --熊大
   TUNING.DEERCLOPS_ATTACK_PERIOD = 1                         --巨鹿
   TUNING.MOOSE_ATTACK_PERIOD = 1                             --鹿角鹅
   TUNING.MINOTAUR_ATTACK_PERIOD = 1                          --远古守护者
   TUNING.BEEQUEEN_ATTACK_PERIOD = 1                          --蜂后
   TUNING.SPIDERQUEEN_ATTACKPERIOD = 1                        --蜘蛛女皇
   TUNING.LEIF_ATTACK_PERIOD = 1                              --树精
   TUNING.WARG_ATTACKPERIOD = 1                               --座狼
   TUNING.WALRUS_ATTACK_PERIOD = 1                            --海象
end

if BIOLOGY_PERIOD then                                        --生物
   TUNING.TALLBIRD_ATTACK_PERIOD = 1                          --高脚鸟
   TUNING.MERM_ATTACK_PERIOD = 1                              --鱼人
   TUNING.WORM_ATTACK_PERIOD = 1                              --蠕虫
   TUNING.WEREPIG_ATTACK_PERIOD = 1                           --疯猪
   TUNING.SPIDER_ATTACK_PERIOD = 1                            --小蜘蛛
   TUNING.SPIDER_WARRIOR_ATTACK_PERIOD = 1                    --蜘蛛战士，白蜘蛛
   TUNING.SPIDER_HIDER_ATTACK_PERIOD = 1                      --洞穴蜘蛛
   TUNING.SPIDER_SPITTER_ATTACK_PERIOD = 1                    --喷吐蜘蛛
   TUNING.HOUND_ATTACK_PERIOD = 1                             --狗
   TUNING.FIREHOUND_ATTACK_PERIOD = 1                         --火狗
   TUNING.ICEHOUND_ATTACK_PERIOD = 1                          --冰狗
end

--护甲（BOSS）
TUNING.BOSS_ARMOR = GetModConfigData("boss_armor")
local function boss_a(inst)
     if inst.components.health then
        inst.components.health:SetAbsorptionAmount(TUNING.BOSS_ARMOR)
	 end
end
AddPrefabPostInit("dragonfly", boss_a)      --龙蝇
AddPrefabPostInit("bearger", boss_a)        --熊大
AddPrefabPostInit("deerclops", boss_a)      --巨鹿
AddPrefabPostInit("moose", boss_a)          --鹿角鹅
AddPrefabPostInit("mossling", boss_a)       --小鸭子
AddPrefabPostInit("minotaur", boss_a)       --远古守护者
AddPrefabPostInit("beequeen", boss_a)       --蜂后
AddPrefabPostInit("toadstool", boss_a)      --普通蛤蟆
AddPrefabPostInit("toadstool_dark", boss_a) --毒蛤蟆
AddPrefabPostInit("spiderqueen", boss_a)    --蜘蛛女皇
AddPrefabPostInit("leif", boss_a)           --树精
AddPrefabPostInit("leif_sparse", boss_a)    --稀有树精
AddPrefabPostInit("warg", boss_a)           --座狼
AddPrefabPostInit("spat", boss_a)           --钢羊
AddPrefabPostInit("walrus", boss_a)         --海象
--护甲（生物）
TUNING.BIOLOGY_ARMOR = GetModConfigData("biology_armor")
local function biology_a(inst)
     if inst.components.health then
        inst.components.health:SetAbsorptionAmount(TUNING.BIOLOGY_ARMOR)
	 end
end
AddPrefabPostInit("koalefant_winter", biology_a) --冬象
AddPrefabPostInit("koalefant_summer", biology_a) --夏象
AddPrefabPostInit("tallbird", biology_a)         --高脚鸟
AddPrefabPostInit("tentacle", biology_a)         --触手
AddPrefabPostInit("merm", biology_a)             --鱼人
AddPrefabPostInit("worm", biology_a)             --蠕虫
AddPrefabPostInit("pigman", biology_a)           --猪人
AddPrefabPostInit("spider", biology_a)           --小蜘蛛
AddPrefabPostInit("spider_warrior", biology_a)   --蜘蛛战士
AddPrefabPostInit("spider_dropper", biology_a)   --白蜘蛛
AddPrefabPostInit("spider_hider", biology_a)     --洞穴蜘蛛
AddPrefabPostInit("spider_spitter", biology_a)   --喷吐蜘蛛
AddPrefabPostInit("hound", biology_a)            --狗
AddPrefabPostInit("firehound", biology_a)        --火狗
AddPrefabPostInit("icehound", biology_a)         --冰狗

--回血（BOSS）
TUNING.BOSS_REGEN = GetModConfigData("boss_regen")
local function boss_h(inst)
     if inst.components.health then
        inst.components.health:StartRegen(TUNING.BOSS_REGEN, 1)	
	 end
end
AddPrefabPostInit("dragonfly", boss_h)      --龙蝇
AddPrefabPostInit("bearger", boss_h)        --熊大
AddPrefabPostInit("deerclops", boss_h)      --巨鹿
AddPrefabPostInit("moose", boss_h)          --鹿角鹅
AddPrefabPostInit("mossling", boss_h)       --小鸭子
AddPrefabPostInit("minotaur", boss_h)       --远古守护者
AddPrefabPostInit("beequeen", boss_h)       --蜂后
AddPrefabPostInit("toadstool", boss_h)      --普通蛤蟆
AddPrefabPostInit("toadstool_dark", boss_h) --毒蛤蟆
AddPrefabPostInit("spiderqueen", boss_h)    --蜘蛛女皇
AddPrefabPostInit("leif", boss_h)           --树精
AddPrefabPostInit("leif_sparse", boss_h)    --稀有树精
AddPrefabPostInit("warg", boss_h)           --座狼
AddPrefabPostInit("spat", boss_h)           --钢羊
AddPrefabPostInit("walrus", boss_h)         --海象
--回血（生物）
TUNING.BIOLOGY_REGEN = GetModConfigData("biology_regen")
local function biology_h(inst)
     if inst.components.health then
        inst.components.health:StartRegen(TUNING.BIOLOGY_REGEN, 1)	
	 end
end
AddPrefabPostInit("koalefant_winter", biology_h) --冬象
AddPrefabPostInit("koalefant_summer", biology_h) --夏象
AddPrefabPostInit("tallbird", biology_h)         --高脚鸟
AddPrefabPostInit("tentacle", biology_h)         --触手
AddPrefabPostInit("merm", biology_h)             --鱼人
AddPrefabPostInit("worm", biology_h)             --蠕虫
AddPrefabPostInit("pigman", biology_h)           --猪人
AddPrefabPostInit("spider", biology_h)           --小蜘蛛
AddPrefabPostInit("spider_warrior", biology_h)   --蜘蛛战士
AddPrefabPostInit("spider_dropper", biology_h)   --白蜘蛛
AddPrefabPostInit("spider_hider", biology_h)     --洞穴蜘蛛
AddPrefabPostInit("spider_spitter", biology_h)   --喷吐蜘蛛
AddPrefabPostInit("hound", biology_h)            --狗
AddPrefabPostInit("firehound", biology_h)        --火狗
AddPrefabPostInit("icehound", biology_h)         --冰狗

--护甲血量
TUNING.ARMORGRASS = 158*GetModConfigData("armour_health")            --草甲血量
TUNING.ARMORWOOD = 315*GetModConfigData("armour_health")             --木甲血量
TUNING.ARMORMARBLE = 735*GetModConfigData("armour_health")           --大理石甲血量
TUNING.ARMORSNURTLESHELL = 735*GetModConfigData("armour_health")     --蜗牛甲血量
TUNING.ARMORRUINS = 1260*GetModConfigData("armour_health")           --远古甲血量
TUNING.ARMOR_FOOTBALLHAT = 315*GetModConfigData("armour_health")     --猪皮帽血量
TUNING.ARMORDRAGONFLY = 945*GetModConfigData("armour_health")        --火甲血量
TUNING.ARMOR_WATHGRITHRHAT = 525*GetModConfigData("armour_health")   --战斗头盔血量
TUNING.ARMOR_RUINSHAT = 840*GetModConfigData("armour_health")        --远古头血量
TUNING.ARMOR_SLURTLEHAT = 525*GetModConfigData("armour_health")      --蜗牛帽血量
TUNING.ARMOR_BEEHAT = 1050*GetModConfigData("armour_health")         --蜂帽血量
TUNING.ARMOR_SANITY = 525*GetModConfigData("armour_health")          --影甲血量

--护甲减伤
if ARMOUR_ARMOR then
   TUNING.ARMORGRASS_ABSORPTION = .7                --草甲减伤
   TUNING.ARMORWOOD_ABSORPTION = .85                --木甲减伤
   --TUNING.ARMORMARBLE_ABSORPTION = .95            --大理石减伤
   TUNING.ARMORSNURTLESHELL_ABSORPTION = 0.7        --蜗牛甲减伤
   TUNING.ARMORRUINS_ABSORPTION = 0.95              --远古甲减伤
   TUNING.ARMOR_FOOTBALLHAT_ABSORPTION = .85        --猪皮帽减伤
   TUNING.ARMORDRAGONFLY_ABSORPTION = 0.8           --火甲减伤
   TUNING.ARMOR_WATHGRITHRHAT_ABSORPTION = .85      --战斗头盔减伤
   TUNING.ARMOR_RUINSHAT_ABSORPTION = 0.95          --远古头减伤
   --TUNING.ARMOR_SLURTLEHAT_ABSORPTION = 0.9       --蜗牛帽减伤
   TUNING.ARMOR_BEEHAT_ABSORPTION = .9              --蜂帽减伤
   --TUNING.ARMOR_SANITY_ABSORPTION = .95           --影甲减伤
end


--武器伤害
   TUNING.NIGHTSWORD_DAMAGE = 34*2*GetModConfigData("arms_damage")                          --影刀
   TUNING.BATBAT_DAMAGE = 34*1.25*GetModConfigData("arms_damage")                           --蝙蝠棒
   TUNING.SPIKE_DAMAGE = 34*1.5*GetModConfigData("arms_damage")                             --触手尖刺
   TUNING.SPEAR_DAMAGE = 34*GetModConfigData("arms_damage")                                 --长矛
   TUNING.WATHGRITHR_SPEAR_DAMAGE = 34*1.25*GetModConfigData("arms_damage")                 --战斗长矛
   TUNING.CANE_DAMAGE = 34*.5*GetModConfigData("arms_damage")                               --步行手杖
   TUNING.RUINS_BAT_DAMAGE = 34*1.75*GetModConfigData("arms_damage")                        --远古武器
   TUNING.NIGHTSTICK_DAMAGE = 34*.85*GetModConfigData("arms_damage")                        --晨星
--武器耐久
   TUNING.NIGHTSWORD_USES = 100*GetModConfigData("arms_uses")                         --影刀
   TUNING.BATBAT_USES = 75*GetModConfigData("arms_uses")                              --蝙蝠棒
   TUNING.SPIKE_USES = 100*GetModConfigData("arms_uses")                              --触手尖刺
   TUNING.SPEAR_USES = 150*GetModConfigData("arms_uses")                              --长矛
   TUNING.WATHGRITHR_SPEAR_USES = 200*GetModConfigData("arms_uses")                   --战斗长矛
   TUNING.RUINS_BAT_USES = 150*GetModConfigData("arms_uses")                          --远古棒
