

PrefabFiles = {
	"mayoi", "san",
	"miho",	
	"mihobell", "lb", "gy", "lb2", "lb3", "lb4",
}

Assets = {


Asset( "IMAGE", "images/minimapicons/miho.tex" ),
	Asset( "ATLAS", "images/minimapicons/miho.xml" ),
	Asset( "IMAGE", "images/minimapicons/mihobell.tex" ),
	Asset( "ATLAS", "images/minimapicons/mihobell.xml" ),
	Asset("ANIM", "anim/ui_chest_3x3.zip"),
Asset( "ANIM", "anim/miho.zip" ),

    Asset( "IMAGE", "images/saveslot_portraits/mayoi.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/mayoi.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/mayoi.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/mayoi.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/mayoi_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/mayoi_silho.xml" ),

    Asset( "IMAGE", "bigportraits/mayoi.tex" ),
    Asset( "ATLAS", "bigportraits/mayoi.xml" ),
	
	Asset( "IMAGE", "images/map_icons/mayoi.tex" ),
	Asset( "ATLAS", "images/map_icons/mayoi.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_mayoi.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_mayoi.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_mayoi.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_mayoi.xml" ),
	
	Asset("ATLAS", "images/inventoryimages/san.xml"),
Asset( "ATLAS", "images/hud/mayoitab.xml" ),

Asset("SOUNDPACKAGE", "sound/mayoi.fev"),
    Asset("SOUND", "sound/mayoi.fsb"),
}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

local resolvefilepath = GLOBAL.resolvefilepath

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local TECH = GLOBAL.TECH
local STRINGS = GLOBAL.STRINGS

_G = GLOBAL


if GetModConfigData("Language") == false then
STRINGS.NAMES.LB = "BossPackage"
STRINGS.RECIPE_DESC.LB = "Contains BossDrop" 

STRINGS.NAMES.LB2 = "War Package"
STRINGS.RECIPE_DESC.LB2 = "Contains weapons" 

STRINGS.NAMES.LB3 = "Food Package"
STRINGS.RECIPE_DESC.LB3 = "Contains Food" 

STRINGS.NAMES.LB4 = "Present from Monoko"


STRINGS.NAMES.GY = "Jade"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GY = "Lucky"
STRINGS.RECIPE_DESC.GY = "Just buying it" 

STRINGS.NAMES.SAN = "Paper umbrella"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.SAN = "Paper umbrella"



STRINGS.NAMES.MIHO = "White"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MIHO = "White"

STRINGS.NAMES.MIHOBELL = "Fox bell"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MIHOBELL = { "Fox bell", }

STRINGS.CHARACTER_TITLES.mayoi = "Kagura"
STRINGS.CHARACTER_NAMES.mayoi = "Kagura"
STRINGS.CHARACTER_DESCRIPTIONS.mayoi = "*Have a paper umbrella\n*Have a pet fox\n*Magic level 1"
STRINGS.CHARACTER_QUOTES.mayoi = "\"Follow me, WHITE\""
end

if GetModConfigData("Language") == true then


STRINGS.NAMES.LB = "boss大礼包"
STRINGS.RECIPE_DESC.LB = "boss材料" 

STRINGS.NAMES.LB2 = "装备大礼包"
STRINGS.RECIPE_DESC.LB2 = "武器防具" 

STRINGS.NAMES.LB3 = "体力大礼包"
STRINGS.RECIPE_DESC.LB3 = "各种料理" 

STRINGS.NAMES.LB4 = "阴阳寮福利"


STRINGS.NAMES.GY = "勾玉"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GY = "Lucky"
STRINGS.RECIPE_DESC.GY = "氪氪氪" 

STRINGS.NAMES.SAN = "通灵伞"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.SAN = "通灵伞"



STRINGS.NAMES.MIHO = "小白"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MIHO = "小白"

STRINGS.NAMES.MIHOBELL = "狐狸铃铛"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MIHOBELL = { "狐狸铃铛", }

STRINGS.CHARACTER_TITLES.mayoi = "阴阳师神乐"
STRINGS.CHARACTER_NAMES.mayoi = "神乐"
STRINGS.CHARACTER_DESCRIPTIONS.mayoi = "*有一把漂亮的伞\n*宠物小白\n*自带一级魔法"
STRINGS.CHARACTER_QUOTES.mayoi = "\"小白快跟上\""
end




-- The character select screen lines


-- Custom speech strings
STRINGS.CHARACTERS.MAYOI = require "speech_mayoi"

-- The character's name as appears in-game 
STRINGS.NAMES.MAYOI = "神乐"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MAYOI = 
{
	GENERIC = "It's Kagura!",
	ATTACKER = "Kagura, what are you doing?",
	MURDERER = "Agh! Murderer!",
	REVIVER = "Kagura is such a lovely girl.",
	GHOST = "Kagura... Are you okay...?",
}



mayoitab = AddRecipeTab("shop", 998, "images/hud/mayoitab.xml", "mayoitab.tex", "mayoi_builder")

 local gy = Ingredient( "gy", 30)
    gy.atlas = "images/inventoryimages/gy.xml"

local gy2 = Ingredient( "gy", 15)
    gy2.atlas = "images/inventoryimages/gy.xml"

local gy3 = Ingredient( "gy", 10)
    gy3.atlas = "images/inventoryimages/gy.xml"


local gy_recipe = AddRecipe("gy",
{Ingredient("goldnugget", 5)},mayoitab, TECH.NONE, nil, nil, nil, 5, nil, "images/inventoryimages/gy.xml", "gy.tex")
gy_recipe.tagneeded = false
gy_recipe.builder_tag = "mayoi_builder"

local lb_recipe = AddRecipe("lb",
{gy},mayoitab, TECH.NONE, nil, nil, nil, nil, nil, "images/inventoryimages/lb.xml", "lb.tex")
lb_recipe.tagneeded = false
lb_recipe.builder_tag = "mayoi_builder"

local lb2_recipe = AddRecipe("lb2",
{gy2},mayoitab, TECH.NONE, nil, nil, nil, nil, nil, "images/inventoryimages/lb2.xml", "lb2.tex")
lb2_recipe.tagneeded = false
lb2_recipe.builder_tag = "mayoi_builder"

local lb3_recipe = AddRecipe("lb3",
{gy3},mayoitab, TECH.NONE, nil, nil, nil, nil, nil, "images/inventoryimages/lb3.xml", "lb3.tex")
lb3_recipe.tagneeded = false
lb3_recipe.builder_tag = "mayoi_builder"



---------------
local params={} 
params.miho ={widget = {slotpos = {},
    animbank = "ui_chest_3x3", animbuild = "ui_chest_3x3",
    pos = _G.Vector3(0, 140, 0), side_align_tip = 160, },
    type = "chest",}
local pot={} 
pot.gumipot ={ widget = { slotpos = {},
    animbank = "ui_chest_3x3", animbuild = "ui_chest_3x3",
    pos = _G.Vector3(-140, 140, 0), side_align_tip = 160, },
    type = "chest",}
for y = 2, 0, -1 do
    for x = 0, 2 do
    table.insert(params.miho.widget.slotpos,
	_G.Vector3(75*x-93*2+109, 75*y-75*2+75, 0))
end end
for y = 2.5, -.5, -1 do
    for x = 0, 1 do
        table.insert(pot.gumipot.widget.slotpos,
		_G.Vector3(75*x-93*2+75, 75*y-75*2+75, 0))
    end
end
local containers = _G.require "containers"
containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS, params.miho.widget.slotpos ~= nil and #params.miho.widget.slotpos or 0)
containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS,pot.gumipot.widget.slotpos ~= nil and #pot.gumipot.widget.slotpos or 0)
local old_widgetsetup = containers.widgetsetup
function containers.widgetsetup(container, prefab, data)
        local pref = prefab or container.inst.prefab
        if pref == "miho" then local t = params[pref]
		if t ~= nil then for k, v in pairs(t) do container[k] = v end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0) end
    else return old_widgetsetup(container, prefab) end end
local new_widgetsetup = containers.widgetsetup
function containers.widgetsetup(container, prefab, data)
    local pref = prefab or container.inst.prefab
	if pref == "gumipot" then local i = pot[pref]
	if i ~= nil then for k, v in pairs(i) do container[k] = v end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0) end
    else return new_widgetsetup(container, prefab) end end

local function GiveMihobell(inst)
	local mihobell = GLOBAL.SpawnPrefab("mihobell")
	if mihobell then
		mihobell.owner = inst
		inst.mihobell = mihobell
		inst.components.inventory.ignoresound = true
		inst.components.inventory:GiveItem(mihobell)
		inst.components.inventory.ignoresound = false
		mihobell.components.named:SetName(inst.name.."Bell")
	return mihobell end end
local function GetSpawnPoint(pt)
	local theta = math.random() * 2 * GLOBAL.PI
	local radius = 4
	local offset = GLOBAL.FindWalkableOffset(pt, theta, radius, 12, true)
	return offset ~= nil and (pt + offset) or nil end
local function PersonalMiho(inst)
	if not inst:HasTag("xbowner") then return	end

	local OnDespawn_prev = inst.OnDespawn
	local OnDespawn_new = function(inst)
		-- Remove miho
		if inst.miho then
			-- Don't allow miho to despawn with irreplaceable items
			inst.miho.components.container:DropEverythingWithTag("irreplaceable")
			-- We need time to save before despawning.
			inst.miho:DoTaskInTime(0.1, function(inst)
				if inst and inst:IsValid() then
					inst:Remove() end end) end
		if inst.mihobell then
			-- Mihobell drops from whatever its in
			local owner = inst.mihobell.components.inventoryitem.owner
			if owner then
				-- Remember if mihobell is held
				if owner == inst then
					inst.mihobell.isheld = true	else
					inst.mihobell.isheld = false end
				if owner.components.container then
					owner.components.container:DropItem(inst.mihobell)
				elseif owner.components.inventory then
					owner.components.inventory:DropItem(inst.mihobell)
				end	end
			-- Remove mihobell
			inst.mihobell:DoTaskInTime(0.1, function(inst)
				if inst and inst:IsValid() then
					inst:Remove() end end) else
			print("Error: Player has no linked mihobell!") end
		if OnDespawn_prev then
			return OnDespawn_prev(inst)	end	end
	inst.OnDespawn = OnDespawn_new
	
	local OnSave_prev = inst.OnSave
	local OnSave_new = function(inst, data)
		local references = OnSave_prev and OnSave_prev(inst, data)
		if inst.miho then
			-- Save miho
			local refs = {}
			if not references then references = {} end
			data.miho, refs = inst.miho:GetSaveRecord()
			if refs then
				for k,v in pairs(refs) do
					table.insert(references, v)
				end end	end
		if inst.mihobell then
			-- Save mihobell
			local refs = {}
			if not references then references = {} end
			data.mihobell, refs = inst.mihobell:GetSaveRecord()
			if refs then
				for k,v in pairs(refs) do
				table.insert(references, v)	end end
			-- Remember if was holding mihobell
			if inst.mihobell.isheld then
				data.holdingmihobell = true	else
				data.holdingmihobell = false
			end	end	return references end
    inst.OnSave = OnSave_new
	
	local OnLoad_prev = inst.OnLoad
	local OnLoad_new = function(inst, data, newents)
		if data.miho ~= nil then
			-- Load miho
		inst.miho = GLOBAL.SpawnSaveRecord(data.miho, newents) else end
			--print("Warning: No miho was loaded from save file!")
		if data.mihobell ~= nil then
			-- Load miho
			inst.mihobell = GLOBAL.SpawnSaveRecord(data.mihobell, newents)
			-- Look for mihobell at spawn point and re-equip
			inst:DoTaskInTime(0, function(inst)
				if data.holdingmihobell or (inst.mihobell and inst:IsNear(inst.mihobell,4)) then
					--inst.components.inventory:GiveItem(inst.mihobell)
					inst:ReturnMihobell()
				end	end) else
			print("Warning: No mihobell was loaded from save file!") end
		-- Create new mihobell if none loaded
		if not inst.mihobell then GiveMihobell(inst) end
		inst.mihobell.owner = inst
		if OnLoad_prev then
			return OnLoad_prev(inst, data, newents)
		end	end inst.OnLoad = OnLoad_new
	local OnNewSpawn_prev = inst.OnNewSpawn
	local OnNewSpawn_new = function(inst)
		-- Give new mihobell. Let miho spawn naturally.
		GiveMihobell(inst)
		if OnNewSpawn_prev then
			return OnNewSpawn_prev(inst) end end
    inst.OnNewSpawn = OnNewSpawn_new
	if GLOBAL.TheNet:GetServerGameMode() == "wilderness" then
		local function ondeath(inst, data)
			-- Kill player's miho in wilderness mode :(
			if inst.miho then inst.miho.components.health:Kill() end
			if inst.mihobell then
				inst.mihobell:Remove()
			end	end	inst:ListenForEvent("death", ondeath) end
	-- Debug function to return mihobell
	inst.ReturnMihobell = function()
		if inst.mihobell and inst.mihobell:IsValid() then
			if inst.mihobell.components.inventoryitem.owner ~= inst then
				inst.components.inventory:GiveItem(inst.mihobell)
			end	else GiveMihobell(inst) end
		if inst.miho and not inst:IsNear(inst.miho, 20) then
			local pt = inst:GetPosition()
			local spawn_pt = GetSpawnPoint(pt)
			if spawn_pt ~= nil then
				inst.miho.Physics:Teleport(spawn_pt:Get())
				inst.miho:FacePoint(pt:Get()) end end end end

GLOBAL.c_returnmihobell = function(inst)
	if not inst then
		inst = GLOBAL.ThePlayer or GLOBAL.AllPlayers[1]	end
	if not inst or not inst.ReturnMihobell then 
		print("Error: Cannot return mihobell")
		return end inst:ReturnMihobell() end
AddPlayerPostInit(PersonalMiho)

local function HasMihobell(doer)
    if doer.components.inventory and doer.components.inventory:FindItem(function(item)
        if item.prefab == "mihobell" or doer:HasTag("xbowner") then return true end
    end) ~= nil then return true else return false end end

local oldMIHOSTORE = GLOBAL.ACTIONS.STORE.fn
GLOBAL.ACTIONS.STORE.fn = function(act)
    if act.target and act.target.prefab == "miho" and act.target.components.container ~= nil and act.invobject.components.inventoryitem ~= nil and act.doer.components.inventory ~= nil then
        print(act.doer.name,"NO")
        if HasMihobell(act.doer) then
            print(act.doer.name,"YES")
            return oldMIHOSTORE(act) else
            print(act.doer.name,"NO")
            if act.doer.components.talker then act.doer.components.talker:Say("NO") end return true
    end else return oldMIHOSTORE(act) end end

local old_MIHOMAGE = GLOBAL.ACTIONS.RUMMAGE.fn 
GLOBAL.ACTIONS.RUMMAGE.fn = function(act)
    if act.target and act.target.prefab == "miho" then  
        print("GLOBAL.ACTIONS.RUMMAGE--"..tostring(act.doer.components.inventory))
        result = act.doer.components.inventory:FindItem(function(item)
            if item.prefab == "mihobell" or act.doer:HasTag("xbowner") then 
            print("GLOBAL.ACTIONS.RUMMAGE--"..tostring(item).."--ok--") 
            return true end end)
        if result then return old_MIHOMAGE(act) else
            print("GLOBAL.ACTIONS.RUMMAGE--"..tostring(item).."--fail--") 
            act.doer:DoTaskInTime(1, function ()
            act.doer.components.talker:Say("NO")
        end) return false end else
    return old_MIHOMAGE(act) end end
-------------------------------------------------------------------------------------------------------------------------------------------



AddMinimapAtlas("images/minimapicons/mihobell.xml")
AddMinimapAtlas("images/minimapicons/miho.xml")
AddMinimapAtlas("images/map_icons/mayoi.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("mayoi", "FEMALE")
if GetModConfigData("Sound") == true then
RemapSoundEvent( "dontstarve/characters/mayoi/death_voice", "mayoi/characters/death_voice" )
RemapSoundEvent( "dontstarve/characters/mayoi/hurt", "mayoi/characters/hurt" )
RemapSoundEvent( "dontstarve/characters/mayoi/talk_LP", "mayoi/characters/talk_LP" )
TUNING.x = "mayoi"
end
if GetModConfigData("Sound") == false then
	TUNING.x = "wilson"
end
