local assets =
{
    Asset("ANIM", "anim/san.zip"),
	Asset("ANIM", "anim/r_san_s.zip"),
	Asset("ATLAS", "images/inventoryimages/san.xml"),
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "r_san_s", "rikka_san_s")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function onattack(inst, attacker, target)



        
        if target:HasTag("shadowcreature") or target:HasTag("shadowchesspiece") then
      target.components.health:DoDelta(-100)
  SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
		

    end
end

local function common_fn(name)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank(name)
    inst.AnimState:SetBuild(name)
    inst.AnimState:PlayAnimation("idle")  
	
	inst.Transform:SetScale(1.8,1.8,1.8)

    inst:AddTag("umbrella")

    --waterproofer (from waterproofer component) added to pristine state for optimization
    inst:AddTag("waterproofer")
	
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("waterproofer")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst:AddComponent("equippable")

    inst:AddComponent("insulator")
    inst.components.insulator:SetSummer()

    return inst
end

local function fn()
    local inst = common_fn("san")

    if not TheWorld.ismastersim then
        return inst
    end    

    inst.components.waterproofer:SetEffectiveness(.8)

    inst.components.insulator:SetInsulation(TUNING.INSULATION_LARGE)

    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	
	   inst.components.inventoryitem.imagename = "san"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/san.xml"
	
	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(5)
 inst:ListenForEvent("onattacker",onattack)
 inst.components.weapon.onattack = onattack
    return inst
end

return Prefab("san", fn, assets)