
local assets =
{
    Asset("ATLAS", "images/inventoryimages/items.xml"),
    Asset("ANIM", "anim/mihobell.zip"),
	Asset( "SOUND" , "sound/bel.fsb" ),
	Asset( "SOUNDPACKAGE" , "sound/bel.fev" ),
}

local SPAWN_DIST = 30

local function OpenEye(inst)
    inst.isOpenEye = true
    inst.components.inventoryitem:ChangeImageName(inst.openEye)
end

local function CloseEye(inst)
    inst.isOpenEye = nil
    inst.components.inventoryitem:ChangeImageName(inst.closedEye)
end

local function RefreshEye(inst)
    if inst.isOpenEye then
        OpenEye(inst)
    else
        CloseEye(inst)
    end
end

local function MorphShadowMihobell(inst)
    inst.AnimState:SetBuild("mihobell")

    inst.openEye = "mihobell"
    inst.closedEye = "mihobell"
    RefreshEye(inst)

    inst.MihobellState = "SHADOW"
end

local function MorphSnowMihobell(inst)
    inst.AnimState:SetBuild("mihobell")

    inst.openEye = "mihobell"
    inst.closedEye = "mihobell"
    RefreshEye(inst)

    inst.MihobellState = "SNOW"
end

local function GetSpawnPoint(pt)
    local theta = math.random() * 2 * PI
    local radius = SPAWN_DIST
    local offset = FindWalkableOffset(pt, theta, radius, 12, true)
    return offset ~= nil and (pt + offset) or nil
end

local function SpawnMiho(inst)
    --print("chester_eyebone - SpawnChester")
	if not inst.owner then
        print("Error: Mihobell has no linked player!")
        return
    end

    local pt = inst:GetPosition()
    --print("    near", pt)
        
    local spawn_pt = GetSpawnPoint(pt)
    if spawn_pt ~= nil then
        --print("    at", spawn_pt)
        local miho = SpawnPrefab("miho")
        if miho ~= nil then
            miho.Physics:Teleport(spawn_pt:Get())
            miho:FacePoint(pt:Get())
			if inst.owner then
                inst.owner.miho = miho
            end

            return miho
        end

    --else
        -- this is not fatal, they can try again in a new location by picking up the bone again
        --print("chester_eyebone - SpawnChester: Couldn't find a suitable spawn point for chester")
    end
end

local StartRespawn

local function StopRespawn(inst)
    --print("chester_eyebone - StopRespawn")
    if inst.respawntask ~= nil then
        inst.respawntask:Cancel()
        inst.respawntask = nil
        inst.respawntime = nil
    end
end

local function RebindMiho(inst, miho)
    miho = miho or (inst.owner and inst.owner.miho)
    if miho ~= nil then
	if inst.owner then
            miho.components.named:SetName(inst.owner.name.."的小狐狸箱")
        end
        inst.AnimState:PlayAnimation("idle_loop", true)
        OpenEye(inst)
        inst:ListenForEvent("death", function()
		 if inst.owner then
                inst.owner.miho = nil
            end
		StartRespawn(inst, TUNING.CHESTER_RESPAWN_TIME) end, miho)

        if miho.components.follower.leader ~= inst then
            miho.components.follower:SetLeader(inst)
        end
        return true
    end
end

local function RespawnMiho(inst)
    --print("chester_eyebone - RespawnChester")
    StopRespawn(inst)
    RebindMiho(inst, (inst.owner and inst.owner.miho) or SpawnMiho(inst))
end

StartRespawn = function(inst, time)
    StopRespawn(inst)

    time = time or 0
    inst.respawntask = inst:DoTaskInTime(time, RespawnMiho)
    inst.respawntime = GetTime() + time
    inst.AnimState:PlayAnimation("dead", true)
    CloseEye(inst)
end

local function FixMiho(inst)
	inst.fixtask = nil
	--take an existing chester if there is one
	if not RebindMiho(inst) then
        inst.AnimState:PlayAnimation("dead", true)
        CloseEye(inst)
		
		if inst.components.inventoryitem.owner ~= nil then
			local time_remaining = 0
			local time = GetTime()
			if inst.respawntime and inst.respawntime > time then
				time_remaining = inst.respawntime - time		
			end
			StartRespawn(inst, time_remaining)
		end
	end
end

local function OnPutInInventory(inst)
    if inst.fixtask == nil then
        inst.fixtask = inst:DoTaskInTime(1, FixMiho)
    end
end
local function OnSound(inst)
	inst.SoundEmitter:PlaySound("bel/bel/bel")
end

local function OnSave(inst, data)
    --print("chester_eyebone - OnSave")
    --data.MihobellState = inst.MihobellState
    if inst.respawntime ~= nil then
        local time = GetTime()
        if inst.respawntime > time then
            data.respawntimeremaining = inst.respawntime - time
        end
    end
end

local function OnLoad(inst, data)
    if data == nil then
        return
    end

    if data.MihobellState == "SHADOW" then
        MorphShadowMihobell(inst)
    elseif data.MihobellState == "SNOW" then
        MorphSnowMihobell(inst)
    end

    if data.respawntimeremaining ~= nil then
        inst.respawntime = data.respawntimeremaining + GetTime()
    end
end

local function GetStatus(inst)
    --print("smallbird - GetStatus")
    if inst.respawntask ~= nil then
        return "WAITING"
    end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
	inst.entity:AddSoundEmitter()
	inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("mihobell.tex")
    MakeInventoryPhysics(inst)

    inst:AddTag("mihobell")
    inst:AddTag("irreplaceable")
    inst:AddTag("nonpotatable")
	inst:AddTag("_named")

    inst.AnimState:SetBank("mihobell")
    inst.AnimState:SetBuild("mihobell")
    inst.AnimState:PlayAnimation("idle_loop", true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst.persists = false

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/items.xml"
	inst.components.inventoryitem:ChangeImageName("mihobell")
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)
	inst.components.inventoryitem:SetOnPutInInventoryFn(OnSound)

    inst.MihobellState = "NORMAL"
    inst.openEye = "mihobell"
    inst.closedEye = "mihobell"

    inst.isOpenEye = nil
    OpenEye(inst)

    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = GetStatus
    inst.components.inspectable:RecordViews()
	inst.components.inspectable.nameoverride = "mihobell"

    inst:AddComponent("leader")
	
	inst:AddComponent("named")

    MakeHauntableLaunch(inst)

    inst.MorphSnowMihobell = MorphSnowMihobell
    inst.MorphShadowMihobell = MorphShadowMihobell

    inst.OnLoad = OnLoad
    inst.OnSave = OnSave

    inst.fixtask = inst:DoTaskInTime(1, FixMiho)
	inst.RebindMiho = RebindMiho

    return inst
end

return Prefab("common/inventory/mihobell", fn, assets)