local CloneState = Class(function(self, inst)
	self.inst = inst

	inst:StartUpdatingComponent(self)
	
	inst:ListenForEvent("oneatsomething", function(inst, data) 
		if data.food and data.food.components.edible then
			if data.food.components.perishable and not data.food.components.perishable:IsFresh() then
				if data.food.components.perishable:IsStale() then
					inst.components.talker:Say("真下流!")
				elseif data.food.components.perishable:IsSpoiled() then
					inst.components.talker:Say("真讨厌!")
				end
			end
		end
	end)
	
	inst:WatchWorldState("startdusk", function()
		inst.components.talker:Say("太阳下山了!")
	end)

	inst:ListenForEvent("torchranout", function(inst, data)
		inst.components.talker:Say("火把火把!")
	end)
end)

function CloneState:InCooldown()
	if self.lastcommenttime then
		local time_since_comment = GetTime() - self.lastcommenttime
		if time_since_comment < 30 then
			return true
		end
	end
	return false
end

function CloneState:OnUpdate()
	if not self:InCooldown() then
		local currenthealth = self.inst.components.health.currenthealth / self.inst.components.health.maxhealth	
		if currenthealth < 0.6 then
			if currenthealth < 0.1 then
				self.inst.components.talker:Say("真不爽!")
			else
				self.inst.components.talker:Say("妈妈!我想吃棒棒糖!")
			end
			self.lastcommenttime = GetTime()
			self.inst.AnimState:PlayAnimation("hungry")
		end
	end
end

return CloneState
