local function onstay(self, stay)
	if self.inst.replica.sonsitcommand then
		self.inst.replica.sonsitcommand._staying:set(stay)
	end
end

local SonSitCommand = Class(function(self, inst)
	self.inst = inst
	self.stay = false
	self.locations = {}
end,
nil, {
	stay = onstay
})

function SonSitCommand:IsCurrentlyStaying()
	return self.inst.replica.sonsitcommand and self.inst.replica.sonsitcommand._staying:value()
end

function SonSitCommand:SetStaying(stay)
	self.stay = stay
end

function SonSitCommand:RememberSitPos(name, pos)
	self.locations[name] = pos
end

function SonSitCommand:OnSave()
	if self:IsCurrentlyStaying() then
		local data = 
		{ 
			stay = self.stay,
			varx = self.locations.currentstaylocation["x"], 
			vary = self.locations.currentstaylocation["y"], 
			varz = self.locations.currentstaylocation["z"]
		}
		return data
	end
end  

function SonSitCommand:OnLoad(data)
	if data then 
		self.stay = data.stay
		self.locations.currentstaylocation = {}
		self.locations.currentstaylocation["x"] = data.varx
		self.locations.currentstaylocation["y"] = data.vary
		self.locations.currentstaylocation["z"] = data.varz
	end
end

return SonSitCommand
