local assets =
{
    Asset("ANIM", "anim/gy.zip"),
	
	Asset("ATLAS", "images/inventoryimages/gy.xml"),
}



local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

   
    inst.AnimState:SetBank("gy")
    inst.AnimState:SetBuild("gy")
    inst.AnimState:PlayAnimation("idle")

   

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("edible")
    inst.components.edible.foodtype = FOODTYPE.ELEMENTAL
    inst.components.edible.hungervalue = 2
    inst:AddComponent("tradable")

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
 inst.components.inventoryitem.imagename = "gy"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/gy.xml"
    inst:AddComponent("stackable")
inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    MakeHauntableLaunchAndSmash(inst)

  

    return inst
end

return Prefab("gy", fn, assets)
