
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/mayoi.zip" ),
        Asset( "ANIM", "anim/ghost_mayoi_build.zip" ),

        Asset("SOUNDPACKAGE", "sound/hc.fev"),
    Asset("SOUND", "sound/hc.fsb"),
      
}
local prefabs = {
}

-- Custom starting items
local start_inv = {
	"san", "lb4",
	"waxwelljournal",
    "nightmarefuel",
    "nightmarefuel",
    "nightmarefuel",
    "nightmarefuel",
    "nightmarefuel",
    "nightmarefuel",
}




local function oneat(inst, food)



if food.prefab == "monstermeat" or food.prefab == "spoiled_food" or food.prefab == "monsterlasagna" or food.prefab == "froglegs" or food.prefab == "wetgoop" or food.prefab == "batwing" or food.prefab == "plantmeat" or food.prefab == "red_cap" or food.prefab == "blue_cap" or food.prefab == "green_cap" then
inst.SoundEmitter:PlaySound("hc/hc/nc")

inst.components.talker:Say("Yucky")
end
if food.prefab == "butterflymuffin" or food.prefab == "frogglebunwich" or food.prefab == "taffy" or food.prefab == "pumpkincookie" or food.prefab == "stuffedeggplant" or food.prefab == "fishsticks" or food.prefab == "honeyham" or food.prefab == "honeynuggets" or food.prefab == "dragonpie" or food.prefab == "mandrakesoup" or food.prefab == "kabobs" or food.prefab == "baconeggs" or food.prefab == "bonestew" or food.prefab == "meatballs" or food.prefab == "perogies" or food.prefab == "turkeydinner" or food.prefab == "fruitmedley" or food.prefab == "ratatouille" or food.prefab == "fishtacos" or food.prefab == "unagi" or food.prefab == "waffles" or food.prefab == "flowersalad" or food.prefab == "watermelonicle" or food.prefab == "icecream" or food.prefab == "trailmix" or food.prefab == "hotchili" or food.prefab == "guacamole" or food.prefab == "jellybean" then
inst.SoundEmitter:PlaySound("hc/hc/hc")	
inst.components.talker:Say("Yammy")
end
end

  local function onkilledother(inst, data)
	local chance = .15
local chance2 = .55
	local victim = data.victim
		if victim:HasTag("monster") then
		if math.random() < chance then
        victim.components.lootdropper:SpawnLootPrefab("gy")
end end 

if victim:HasTag("largecreature") then
		if math.random() < chance2 then
        victim.components.lootdropper:SpawnLootPrefab("gy")
victim.components.lootdropper:SpawnLootPrefab("gy")
victim.components.lootdropper:SpawnLootPrefab("gy")
end end

end

local function DoEffects(pet)
    local x, y, z = pet.Transform:GetWorldPosition()
    SpawnPrefab("shadow_despawn").Transform:SetPosition(x, y, z)
    SpawnPrefab("statue_transition_2").Transform:SetPosition(x, y, z)
end

local function KillPet(pet)
    pet.components.health:Kill()
end

local function OnSpawnPet(inst, pet)
    if pet:HasTag("shadowminion") then
        --Delayed in case we need to relocate for migration spawning
        pet:DoTaskInTime(0, DoEffects)

        if not (inst.components.health:IsDead() or inst:HasTag("playerghost")) then
            inst.components.sanity:AddSanityPenalty(pet, TUNING.SHADOWWAXWELL_SANITY_PENALTY[string.upper(pet.prefab)])
            inst:ListenForEvent("onremove", inst._onpetlost, pet)
        elseif pet._killtask == nil then
            pet._killtask = pet:DoTaskInTime(math.random(), KillPet)
        end
    elseif inst._OnSpawnPet ~= nil then
        inst:_OnSpawnPet(pet)
    end
end

local function OnDespawnPet(inst, pet)
    if pet:HasTag("shadowminion") then
        DoEffects(pet)
        pet:Remove()
    elseif inst._OnDespawnPet ~= nil then
        inst:_OnDespawnPet(pet)
    end
end

local function OnDeath(inst)
    for k, v in pairs(inst.components.petleash:GetPets()) do
        if v:HasTag("shadowminion") and v._killtask == nil then
            v._killtask = v:DoTaskInTime(math.random(), KillPet)
        end
    end
end
 
-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "mayoi.tex" )
	inst:AddTag("mayoi_builder")
inst:AddTag("xbowner")

	inst:AddTag("shadowmagic")
    inst:AddTag("dappereffects")

    --reader (from reader component) added to pristine state for optimization
    inst:AddTag("reader")
	inst:AddTag("bookbuilder")

end
	
-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)

	local light = inst.entity:AddLight()
	inst.Light:Enable(true)
	inst.Light:SetRadius(10)
	inst.Light:SetFalloff(.5)
	inst.Light:SetIntensity(0.9)
	inst.Light:SetColour(245/85,85/85,245/85)

	inst:AddComponent("reader")
	
	inst.components.builder.science_bonus = 1
	
	if inst.components.petleash ~= nil then
        inst._OnSpawnPet = inst.components.petleash.onspawnfn
        inst._OnDespawnPet = inst.components.petleash.ondespawnfn
        inst.components.petleash:SetMaxPets(inst.components.petleash:GetMaxPets() + 4)
    else
        inst:AddComponent("petleash")
        inst.components.petleash:SetMaxPets(4)
    end
    inst.components.petleash:SetOnSpawnFn(OnSpawnPet)
    inst.components.petleash:SetOnDespawnFn(OnDespawnPet)

    inst.components.sanity.dapperness = TUNING.DAPPERNESS_LARGE * 2
	
	inst._onpetlost = function(pet) inst.components.sanity:RemoveSanityPenalty(pet) end
	
	inst:ListenForEvent("death", OnDeath)
    inst:ListenForEvent("ms_becomeghost", OnDeath)

	-- choose which sounds this character will play
    local x = TUNING.x
	inst.soundsname = x
	
inst:AddComponent("sanityaura")
inst.components.sanityaura.aura = TUNING.SANITYAURA_LARGE	
inst.Transform:SetScale(1.2,1.2,1.2)	
	-- Stats	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(200)

inst.components.locomotor.walkspeed = 4.5
     inst.components.locomotor.runspeed = 6.5
	-- Sanity multiplier (optional)
	inst.components.eater:SetOnEatFn(oneat)
	
inst.components.builder.magic_bonus = 2

	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	inst.components.combat.damagemultiplier = 1
	

inst:ListenForEvent("killed", onkilledother)




	
end

return MakePlayerCharacter("mayoi", prefabs, assets, common_postinit, master_postinit, start_inv)
