


require "prefabutil"
local brain = require "brains/mihobrain"

local WAKE_TO_FOLLOW_DISTANCE = 14
local SLEEP_NEAR_LEADER_DISTANCE = 7

local assets =
{
   Asset("ANIM", "anim/ui_chest_3x3.zip"),
   Asset( "ANIM", "anim/miho.zip" ),
   
}

local prefabs =
{
    "mihobell",
}

local function OnOpen(inst)
    if not inst.components.health:IsDead() then
        inst.sg:GoToState("open")
    end
end

local function OnClose(inst)
    if not inst.components.health:IsDead() and inst.sg.currentstate.name ~= "transition" then
        inst.sg:GoToState("close")
    end
end

local function OnStopFollowing(inst)
    inst:RemoveTag("companion")
end

local function OnStartFollowing(inst)
    inst:AddTag("companion")
end

local function MorphShadowMiho(inst)
    inst.AnimState:SetBuild("miho")
    inst:AddTag("spoiler")

    inst.components.container:WidgetSetup("miho")

    local leader = inst.components.follower.leader    
    if leader ~= nil then
        inst.components.follower.leader:MorphShadowEyebone()
    end

    inst.MihoState = "SHADOW"
    inst._isshadowmiho:set(true)
end

local function MorphSnowMiho(inst)
    inst.AnimState:SetBuild("miho")
    inst:AddTag("fridge")

    local leader = inst.components.follower.leader
    if leader ~= nil then
        inst.components.follower.leader:MorphSnowEyebone()
    end

    inst.MihoState = "SNOW"
    inst._isshadowmiho:set(false)
end

local function MorphNormalMiho(inst)
    inst.AnimState:SetBuild("miho")
    inst:RemoveTag("fridge")
    inst:RemoveTag("spoiler")

    inst.components.container:WidgetSetup("miho")

    local leader = inst.components.follower.leader    
    if leader ~= nil then
        inst.components.follower.leader:MorphNormalEyebone()
    end

    inst.MihoState = "NORMAL"
    inst._isshadowmiho:set(false)
end

--[[local function CanMorph(inst)
    if inst.MihoState ~= "NORMAL" or not TheWorld.state.isfullmoon then
        return false, false
    end

    local container = inst.components.container
    if container:IsOpen() then
        return false, false
    end

    local canShadow = true
    local canSnow = true

    for i = 1, container:GetNumSlots() do
        local item = container:GetItemInSlot(i)
        if item == nil then
            return false, false
        end

        canShadow = canShadow and item.prefab == "nightmarefuel"
        canSnow = canSnow and item.prefab == "bluegem"

        if not (canShadow or canSnow) then
            return false, false
        end
    end

    return canShadow, canSnow
end

local function CheckForMorph(inst)
    local canShadow, canSnow = CanMorph(inst)
    if canShadow or canSnow then
        inst.sg:GoToState("transition")
    end
end

local function DoMorph(inst, fn)
    inst.MorphChester = nil
    inst:StopWatchingWorldState("isfullmoon", CheckForMorph)
    inst:RemoveEventCallback("onclose", CheckForMorph)
    fn(inst) 
end
local function MorphMiho(inst)
    local canShadow, canSnow = CanMorph(inst)
    if not (canShadow or canSnow) then
        return
    end

    local container = inst.components.container
    for i = 1, container:GetNumSlots() do
        container:RemoveItem(container:GetItemInSlot(i)):Remove()
    end

    DoMorph(inst, canShadow and MorphShadowMiho or MorphSnowMiho)
end]]

local function OnSave(inst, data)
    data.MihoState = inst.MihoState
end

local function OnPreLoad(inst, data)
    if data == nil then
        return
    elseif data.MihoState == "SHADOW" then
        DoMorph(inst, MorphShadowMiho)
    elseif data.MihoState == "SNOW" then
        DoMorph(inst, MorphSnowMiho)
    end
end

local function OnIsShadowMihoDirty(inst)
    if inst._isshadowmiho:value() ~= inst._clientshadowmorphed then
        inst._clientshadowmorphed = inst._isshadowmiho:value()
        inst.replica.container:WidgetSetup(inst._clientshadowmorphed and "miho" or nil)
    end
end

local function create_miho()

    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddDynamicShadow()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()
	inst.entity:AddLight()
	
	inst.Light:Enable(true)
	inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.5)
    inst.Light:SetIntensity(.4)
    inst.Light:SetColour(150/255,150/255, 0/255)
	inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )

    MakeCharacterPhysics(inst, 75, .5)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)

    inst:AddTag("companion")
    inst:AddTag("character")
    inst:AddTag("scarytoprey")
    inst:AddTag("miho")
    inst:AddTag("notraptrigger")
    inst:AddTag("_named")

    inst.MiniMapEntity:SetIcon("miho.tex")
    inst.MiniMapEntity:SetCanUseCache(false)

    inst.AnimState:SetBank("miho")
    inst.AnimState:SetBuild("miho")

    inst.DynamicShadow:SetSize(2, 1.5)

    inst.Transform:SetFourFaced()

    inst._isshadowmiho = net_bool(inst.GUID, "_isshadowmiho", "onisshadowmihodirty")

    inst.entity:SetPristine()
	
    if not TheWorld.ismastersim then
		inst:DoTaskInTime(0.1, function(inst)
			inst.replica.container:WidgetSetup(inst._isshadowmiho:value() and "miho")
		end)
        inst._clientshadowmorphed = false
        inst:ListenForEvent("onisshadowmihodirty", OnIsShadowMihoDirty)
        return inst
    end
	
	inst.persists = false

    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(233)
    inst.components.health:StartRegen(100, 1)
	inst.components.health.invincible = true
	inst.components.health.fire_damage_scale = 0
    inst:AddTag("noauradamage")

    inst:AddComponent("inspectable")
    inst.components.inspectable:RecordViews()
    --inst.components.inspectable.getstatus = GetStatus
    inst.components.inspectable.nameoverride = "miho"

    inst:AddComponent("locomotor")
    inst.components.locomotor.walkspeed = 8
    inst.components.locomotor.runspeed = 9

    inst:AddComponent("follower")
    inst:ListenForEvent("stopfollowing", OnStopFollowing)
    inst:ListenForEvent("startfollowing", OnStartFollowing)

    inst:AddComponent("knownlocations")

    inst:AddComponent("container")
    inst.components.container:WidgetSetup("miho")
    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose

    inst:AddComponent("named")

    MakeHauntableDropFirstItem(inst)
    AddHauntableCustomReaction(inst, function(inst, haunter)
        if math.random() <= TUNING.HAUNT_CHANCE_ALWAYS then
            inst.components.hauntable.panic = true
            inst.components.hauntable.panictimer = TUNING.HAUNT_PANIC_TIME_SMALL
            inst.components.hauntable.hauntvalue = TUNING.HAUNT_SMALL
            return true
        end
        return false
    end, false, false, true)

    inst:SetStateGraph("SGmiho")
    inst.sg:GoToState("idle")

    inst:SetBrain(brain)
    inst.MihoState = "NORMAL"
    --[[inst.MorphChester = MorphMiho
    inst:WatchWorldState("isfullmoon", CheckForMorph)
    inst:ListenForEvent("onclose", CheckForMorph)]]
    inst.OnSave = OnSave
    inst.OnPreLoad = OnPreLoad

    return inst
end

return Prefab("common/miho", create_miho, assets, prefabs)