Scriptname ZDB_DawnbreakerRefScript01 extends ReferenceAlias

Spell Property ZDB_01_DawnbreakerCloak Auto
Weapon Property ZDB_DawnbreakerTwoHanded Auto
Weapon Property DA09Dawnbreaker Auto

ReferenceAlias Property DawnbreakerAlias Auto
ReferenceAlias Property OwnerAlias Auto
Actor OwnerActor
Actor NewActor
ObjectReference NewContainer

Function CheckOwner()
	OwnerActor = (OwnerAlias.GetRef() as Actor)
EndFunction

Event OnItemRemoved(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akDestContainer)
NewActor = (akDestContainer as Actor)
NewContainer = (akDestContainer as ObjectReference)

IF (akBaseItem == DA09Dawnbreaker) || (akBaseItem == ZDB_DawnbreakerTwoHanded)
	If akDestContainer == None
		DawnbreakerAlias.ForceRefTo(akItemReference)
	Elseif NewActor
		OwnerAlias.ForceRefTo(NewActor)
		If (NewActor.GetEquippedWeapon(True) == DA09Dawnbreaker) ||  (NewActor.GetEquippedWeapon(False) == DA09Dawnbreaker) || (NewActor.GetEquippedWeapon(True) == ZDB_DawnbreakerTwoHanded) ||  (NewActor.GetEquippedWeapon(False) == ZDB_DawnbreakerTwoHanded)
			AddCloak(NewActor)
		Endif
	Elseif NewContainer
		OwnerAlias.ForceRefTo(NewContainer)
	Endif
ENDIF
EndEvent

Function AddCloak(Actor akActor)
IF !(akActor.HasSpell(ZDB_01_DawnbreakerCloak))
	akActor.AddSpell(ZDB_01_DawnbreakerCloak, False)
ENDIF
EndFunction

Function RemoveCloak(Actor akActor)
	akActor.RemoveSpell(ZDB_01_DawnbreakerCloak)
EndFunction

Event OnObjectEquipped(Form akBaseObject, ObjectReference akReference)
IF (akBaseObject == DA09Dawnbreaker) || (akBaseObject == ZDB_DawnbreakerTwoHanded)
	CheckOwner()
	AddCloak(OwnerActor)
ENDIF
EndEvent

Event OnObjectUnequipped(Form akBaseObject, ObjectReference akReference)
IF (akBaseObject == DA09Dawnbreaker) || (akBaseObject == ZDB_DawnbreakerTwoHanded)
	CheckOwner()
	RemoveCloak(OwnerActor)
ENDIF
EndEvent
;--------------------------------------------------------------------------------
;	RESET EVENTS
;--------------------------------------------------------------------------------
Function ResetCloak(Actor akActor)
IF !(akActor == Game.GetPlayer())
	akActor.RemoveSpell(ZDB_01_DawnbreakerCloak)
	Utility.Wait(0.1)
	akActor.AddSpell(ZDB_01_DawnbreakerCloak, False)
ENDIF
EndFunction

Event OnCellAttach()
	ResetCloak(GetRef() as Actor)
EndEvent

Event OnLoad()
	ResetCloak(GetRef() as Actor)
EndEvent

Event OnCombatStateChanged(Actor akTarget, int aeCombatState)
	ResetCloak(GetRef() as Actor)
EndEvent

