Scriptname ZEM_EquipScript01 extends activemagiceffect  

Armor Property ZEM_ArmorLight Auto
Armor Property DA02Armor Auto
GlobalVariable Property ZEM_ArmorLightCheck Auto
ObjectReference Property DA02PillarRef Auto

Message Property ZEM_Armor_SwitchingMessageHeavy Auto
Message Property ZEM_Armor_SwitchingMessageLight Auto


Event OnEffectStart (Actor akTarget, Actor akCaster)
IF (ZEM_ArmorLightCheck.GetValue() == 1) && (akTarget == Game.GetPlayer())
	If (akTarget.GetActorValue("LightArmor")) > (akTarget.GetActorValue("HeavyArmor"))
		SwitchToLight(akTarget)
	Else
		SwitchToHeavy(akTarget)
	Endif
	ZEM_ArmorLightCheck.SetValue(0)
ELSEIF (akTarget.GetDistance(DA02PillarRef) <= 200) && (ZEM_ArmorLightCheck.GetValue() == 0)
	ZEM_ArmorLightCheck.SetValue(2)
	If akTarget.GetItemCount(DA02Armor) >= 1
		Int LightChoice = ZEM_Armor_SwitchingMessageLight.Show()
		If LightChoice == 0
		SwitchToLight(akTarget)
		Endif
	Else
		Int HeavyChoice = ZEM_Armor_SwitchingMessageHeavy.Show()
		If HeavyChoice == 0
			SwitchToHeavy(akTarget)
		Endif
	Endif
	Utility.Wait(0.1)
	ZEM_ArmorLightCheck.SetValue(0)
ENDIF
EndEvent

Function SwitchToLight(Actor akTarget)
If akTarget.GetItemCount(DA02Armor) >= 1
	akTarget.EquipItem(ZEM_ArmorLight,False,True)
	akTarget.RemoveItem(DA02Armor,1,True,None)
Endif
EndFunction

Function SwitchToHeavy(Actor akTarget)
If akTarget.GetItemCount(ZEM_ArmorLight) >= 1
	akTarget.EquipItem(DA02Armor,False,True)
	akTarget.RemoveItem(ZEM_ArmorLight,1,True,None)
Endif
EndFunction