Scriptname ZGA_GauldurEffect02 extends activemagiceffect  

MiscObject Property ZGA_GauldurEffectSpellEffect_Block Auto

FormList Property ZGA_GauldurList_Alchemy Auto
FormList Property ZGA_GauldurList_Alteration Auto
FormList Property ZGA_GauldurList_Archery Auto
FormList Property ZGA_GauldurList_Block Auto
FormList Property ZGA_GauldurList_Conjuration Auto
FormList Property ZGA_GauldurList_Destruction Auto
FormList Property ZGA_GauldurList_Enchanting Auto
FormList Property ZGA_GauldurList_HeavyArmor Auto
FormList Property ZGA_GauldurList_Illusion Auto
FormList Property ZGA_GauldurList_LightArmor Auto
FormList Property ZGA_GauldurList_Lockpicking Auto
FormList Property ZGA_GauldurList_OneHanded Auto
FormList Property ZGA_GauldurList_Pickpocketing Auto
FormList Property ZGA_GauldurList_Restoration Auto
FormList Property ZGA_GauldurList_Smithing Auto
FormList Property ZGA_GauldurList_Sneak Auto
FormList Property ZGA_GauldurList_Speech Auto
FormList Property ZGA_GauldurList_TwoHanded Auto

FormList Property ZGA_GauldurList_OverrideAlchemist Auto
FormList Property ZGA_GauldurList_OverrideSmithing Auto
FormList Property ZGA_GauldurList_OverrideSpeech Auto

FormList Property ZGA_GauldurList_NoSkill Auto
FormList Property ZGA_GauldurList_NoSkillSpell Auto

Event OnEffectStart(Actor akTarget, Actor akCaster)
if (akTarget.GetItemCount(ZGA_GauldurEffectSpellEffect_Block) == 0) && (akCaster == Game.GetPlayer())
IF (akCaster.HasLOS(akTarget))
	AbsorbKnowledge(akTarget, akCaster)
ELSE
	RegisterForSingleLOSGain(akCaster, akTarget)
ENDIF
endif
EndEvent

Event OnGainLOS(Actor akViewer, ObjectReference akTarget)
	AbsorbKnowledge((akTarget as Actor), akViewer)
EndEvent

String Skill01
Float Skill01XP
Class ActorClass

Function AbsorbKnowledge(Actor akTarget, Actor akCaster)
	akTarget.AddItem(ZGA_GauldurEffectSpellEffect_Block,1,True)

	If ZGA_GauldurList_NoSkill.HasForm(akTarget.GetActorBase())
		Return
	Endif
	If (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(0))) || (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(1))) || (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(2))) || (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(3)))|| (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(4)))|| (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(5)))|| (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(6)))|| (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(7)))|| (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(8)))|| (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(9)))|| (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(10))|| (akTarget.HasSpell(ZGA_GauldurList_NoSkillSpell.GetAt(11))))
		Return
	Endif

	ActorClass = akTarget.GetLeveledActorBase().GetClass()
	Skill01 = GenerateSkill(akTarget)
	If (ZGA_GauldurList_OverrideAlchemist.HasForm(akTarget.GetActorBase()))
		Skill01 = "Alchemy"
	Endif
	If (ZGA_GauldurList_OverrideSmithing.HasForm(akTarget.GetActorBase()))
		Skill01 = "Smithing"
	Endif
	If (ZGA_GauldurList_OverrideSpeech.HasForm(akTarget.GetActorBase()))
		Skill01 = "Speechcraft"
	Endif

	Skill01XP = FindXP(Skill01)
	Float AdvanceSkill01 = Skill01XP/(100/akTarget.GetActorValue(Skill01))

	Game.AdvanceSkill(Skill01,AdvanceSkill01)
	String SkillName01 = FindName(Skill01)
	;Debug.Notification(SkillName01+" skill increased.")
EndFunction
;-----------------------------------------------------------------------------------------------------------
; These functions randomly select skills from the options available and provide
; the information on how they should be increased
;-----------------------------------------------------------------------------------------------------------
String Function GenerateSkill(Actor akTarget)
	Int[] SkillArray = new Int[18]
	SkillArray[0] = ReturnKnowledgeSkill(0)
	SkillArray[1] = ReturnKnowledgeSkill(1)
	SkillArray[2] = ReturnKnowledgeSkill(2)
	SkillArray[3] = ReturnKnowledgeSkill(3)
	SkillArray[4] = ReturnKnowledgeSkill(4)
	SkillArray[5] = ReturnKnowledgeSkill(5)
	SkillArray[6] = ReturnKnowledgeSkill(6)
	SkillArray[7] = ReturnKnowledgeSkill(7)
	SkillArray[8] = ReturnKnowledgeSkill(8)
	SkillArray[9] = ReturnKnowledgeSkill(9)
	SkillArray[10] = ReturnKnowledgeSkill(10)
	SkillArray[11] = ReturnKnowledgeSkill(11)
	SkillArray[12] = ReturnKnowledgeSkill(12)
	SkillArray[13] = ReturnKnowledgeSkill(13)
	SkillArray[14] = ReturnKnowledgeSkill(14)
	SkillArray[15] = ReturnKnowledgeSkill(15)
	SkillArray[16] = ReturnKnowledgeSkill(16)
	SkillArray[17] = ReturnKnowledgeSkill(17)

	String[] SkillNameArray = new String[18]
	SkillNameArray[0] = "TwoHanded"
	SkillNameArray[1] = "Alchemy"
	SkillNameArray[2] = "Alteration"
	SkillNameArray[3] = "Block"
	SkillNameArray[4] = "Conjuration"
	SkillNameArray[5] = "Destruction"
	SkillNameArray[6] = "Enchanting"
	SkillNameArray[7] = "HeavyArmor"
	SkillNameArray[8] = "Illusion"
	SkillNameArray[9] = "LightArmor"
	SkillNameArray[10] = "Lockpicking"
	SkillNameArray[11] = "Marksman"
	SkillNameArray[12] = "OneHanded"
	SkillNameArray[13] = "Pickpocket"
	SkillNameArray[14] = "Restoration"
	SkillNameArray[15] = "Smithing"
	SkillNameArray[16] = "Sneak"
	SkillNameArray[17] = "Speechcraft"

	Int TotalOptions = SkillArray[0]+SkillArray[1]+SkillArray[2]+SkillArray[3]+SkillArray[4]+SkillArray[5]+SkillArray[6]+SkillArray[7]+SkillArray[8]+SkillArray[9]+SkillArray[10]+SkillArray[11]+SkillArray[12]+SkillArray[13]+SkillArray[14]+SkillArray[15]+SkillArray[16]+SkillArray[17]
	String[] Skill05Array = new String[5]
	Int Skill05Int = 0
	Skill05Array[0] = ""
	IF TotalOptions >= 1
		While Skill05Array[0] == ""
			If SkillArray[Skill05Int] == 1
				Skill05Array[0] = SkillNameArray[Skill05Int]
				SkillArray[Skill05Int] = 0
			Else
				Skill05Int += 1
			Endif
		EndWhile
	ENDIF
	Int Skill04Int = 0
	Skill05Array[1] = ""
	IF TotalOptions >= 2
		While Skill05Array[1] == ""
			If SkillArray[Skill04Int] == 1
				Skill05Array[1] = SkillNameArray[Skill04Int]
				SkillArray[Skill04Int] = 0
			Else
				Skill04Int += 1
			Endif
		EndWhile
	ENDIF
	Int Skill03Int = 0
	Skill05Array[2] = ""
	IF TotalOptions >= 3
		While Skill05Array[2] == ""
			If SkillArray[Skill03Int] == 1
				Skill05Array[2] = SkillNameArray[Skill03Int]
				SkillArray[Skill03Int] = 0
			Else
				Skill03Int += 1
			Endif
		EndWhile
	ENDIF
	Int Skill02Int = 0
	Skill05Array[3] = ""
	IF TotalOptions >= 4
		While Skill05Array[3] == ""
			If SkillArray[Skill02Int] == 1
				Skill05Array[3] = SkillNameArray[Skill02Int]
				SkillArray[Skill02Int] = 0
			Else
				Skill02Int += 1
			Endif
		EndWhile
	ENDIF
	Int Skill01Int = 0
	Skill05Array[4] = ""
	IF TotalOptions >= 5
		While Skill05Array[4] == ""
			If SkillArray[Skill01Int] == 1
				Skill05Array[4] = SkillNameArray[Skill01Int]
				SkillArray[Skill01Int] = 0
			Else
				Skill01Int += 1
			Endif
		EndWhile
	ENDIF
	String FinalSkill = Skill05Array[Utility.RandomInt(0,(TotalOptions - 1))]
	IF FinalSkill == ""
		Return "Speech"
	ELSE
		Return FinalSkill
	ENDIF
EndFunction

FormList RetrievalList
Int Function ReturnKnowledgeSkill(Int ArrayInt)
	FormList[] FormListArray = new FormList[18]
	FormListArray[0] = ZGA_GauldurList_TwoHanded
	FormListArray[1] = ZGA_GauldurList_Alchemy
	FormListArray[2] = ZGA_GauldurList_Alteration
	FormListArray[3] = ZGA_GauldurList_Block
	FormListArray[4] = ZGA_GauldurList_Conjuration
	FormListArray[5] = ZGA_GauldurList_Destruction
	FormListArray[6] = ZGA_GauldurList_Enchanting
	FormListArray[7] = ZGA_GauldurList_HeavyArmor
	FormListArray[8] = ZGA_GauldurList_Illusion
	FormListArray[9] = ZGA_GauldurList_LightArmor
	FormListArray[10] = ZGA_GauldurList_Lockpicking
	FormListArray[11] = ZGA_GauldurList_Archery
	FormListArray[12] = ZGA_GauldurList_OneHanded
	FormListArray[13] = ZGA_GauldurList_Pickpocketing
	FormListArray[14] = ZGA_GauldurList_Restoration
	FormListArray[15] = ZGA_GauldurList_Smithing
	FormListArray[16] = ZGA_GauldurList_Sneak
	FormListArray[17] = ZGA_GauldurList_Speech

	RetrievalList = FormListArray[ArrayInt]
	If RetrievalList.HasForm(ActorClass)
		Return 1
	Else
		Return 0
	Endif
EndFunction



Float Function FindXP(String SkillString)
	If SkillString == "OneHanded"
		Return 62.38
	ElseIf SkillString == "TwoHanded"
		Return 66.05
	ElseIf SkillString == "Marksman"
		Return 42.25
	ElseIf SkillString == "Block"
		Return 48.52
	ElseIf SkillString == "Smithing"
		Return 393.01
	ElseIf SkillString == "HeavyArmor"
		Return 103.42
	ElseIf SkillString == "LightArmor"
		Return 98.25
	ElseIf SkillString == "Pickpocket"
		Return 48.52
	ElseIf SkillString == "Lockpicking"
		Return 8.73
	ElseIf SkillString == "Sneak"
		Return 34.93
	ElseIf SkillString == "Alchemy"
		Return 524.01
	ElseIf SkillString == "Speechcraft"
		Return 1091.70
	ElseIf SkillString == "Alteration"
		Return 131.00
	ElseIf SkillString == "Conjuration"
		Return 187.14
	ElseIf SkillString == "Destruction"
		Return 291.12
	ElseIf SkillString == "Illusion"
		Return 85.43
	ElseIf SkillString == "Restoration"
		Return 196.50
	ElseIf SkillString == "Enchanting"
		Return 0.43
	EndIf 
EndFunction

String Function FindName(String SkillString)
	If SkillString == "OneHanded"
		Return "One-Handed"
	ElseIf SkillString == "TwoHanded"
		Return "Two-Handed"
	ElseIf SkillString == "Marksman"
		Return "Archery"
	ElseIf SkillString == "HeavyArmor"
		Return "Heavy Armor"
	ElseIf SkillString == "LightArmor"
		Return "Light Armor"
	ElseIf SkillString == "Speechcraft"
		Return "Speech"
	Else
		Return SkillString
	EndIf 
EndFunction
