Scriptname ZNB_SprigganDeathScript01 extends ActiveMagicEffect

Race Property SprigganEarthMotherRace Auto
Race Property SprigganMatronRace Auto
Race Property DLC2SprigganBurntRace Auto
Race Property SprigganRace Auto

Ingredient Property ZNB_SprigganSap_Violet Auto
Ingredient Property ZNB_SprigganSap_Golden Auto
Ingredient Property ZNB_SprigganSap_Burnt Auto
Ingredient Property SprigganSap Auto

Ingredient Property DLC2BurntSprigganWood Auto
Ingredient Property Taproot Auto

Message Property ZNB_NettlebaneMessage Auto

Weapon Property T03Nettlebane Auto
Int DoOnce = 0

Actor SprigganActor

Event OnDeath(Actor akKiller)
SprigganActor = GetTargetActor()
	SprigganActor.RemoveAllItems()
	SprigganActor.BlockActivation(True)
	If (SprigganActor.GetRace() == DLC2SprigganBurntRace)
		SprigganActor.AddItem(DLC2BurntSprigganWood,1)
	Else
		SprigganActor.AddItem(Taproot,1)
	Endif
EndEvent

Event OnActivate (ObjectReference ActionRef)
SprigganActor = GetTargetActor()
If (DoOnce == 0) && (SprigganActor.IsDead()) && (Game.GetPlayer().GetItemCount(T03Nettlebane)>=1) && ((ActionRef as Actor) == Game.GetPlayer())
	Int Choice = ZNB_NettlebaneMessage.Show()
	If Choice == 0
		DoOnce=1
		If (SprigganActor.GetRace() == SprigganRace)
			ActionRef.AddItem(SprigganSap,Utility.RandomInt(1,3))
		Elseif (SprigganActor.GetRace() == DLC2SprigganBurntRace)
			ActionRef.AddItem(ZNB_SprigganSap_Burnt,Utility.RandomInt(1,3))
		Elseif (SprigganActor.GetRace() == SprigganMatronRace)
			ActionRef.AddItem(ZNB_SprigganSap_Golden,Utility.RandomInt(1,3))
		Elseif (SprigganActor.GetRace() == SprigganEarthMotherRace)
			ActionRef.AddItem(ZNB_SprigganSap_Violet,Utility.RandomInt(1,3))
		Endif
	Else
		SprigganActor.Activate(ActionRef, True)
	Endif
Else
	SprigganActor.Activate(ActionRef, True)
Endif
EndEvent