Scriptname ZRN_NamiraScript02 extends activemagiceffect

Actor CorpseActor

Keyword Property ActorTypeNPC Auto
Keyword Property ActorTypeDaedra Auto
MiscObject Property ZRN_NamiraCannibalismEffectEaten Auto
Armor Property DA11RingofNamira Auto
Spell Property ZRN_NamiraCannibalism Auto

Idle Property Cannibalism Auto
Sound Property ZRN_NamiraCannibalismEffectEatenSound Auto

Spell Property ZRN_NamiraCannibalismHeal Auto
Spell Property ZRN_NamiraCannibalismHealRing Auto

EffectShader Property ZRN_CannibalFXS Auto
ImageSpaceModifier Property BerserkerMainImod auto


String Skill01
Float Skill01XP

Event OnEffectStart(Actor akTarget, Actor akCaster)
	CorpseActor = None
	If (akTarget.IsDead()) && (akTarget.HasKeyword(ActorTypeNPC)) && !(akTarget.HasKeyword(ActorTypeDaedra))
		CorpseActor = akTarget
	Endif

	IF !(CorpseActor == None) && (akCaster == Game.GetPlayer()) && (CorpseActor.GetItemCount(ZRN_NamiraCannibalismEffectEaten) == 0)
		CorpseActor.AddItem(ZRN_NamiraCannibalismEffectEaten,1)
		Game.DisablePlayerControls(true,true,false,false,false,false,false,false,0)
		BerserkerMainImod.ApplyCrossFade(0.5)
		ZRN_CannibalFXS.Play(akCaster)

		If Game.GetPlayer().IsWeaponDrawn()
			Utility.Wait(0.5)
		Endif
		Game.GetPlayer().PlayIdle(Cannibalism)
		ZRN_NamiraCannibalismEffectEatenSound.Play(Game.GetPlayer())
		GrantSkillBoost(Game.GetPlayer())
		If Game.GetPlayer().IsEquipped(DA11RingofNamira)
			Game.GetPlayer().DoCombatSpellApply(ZRN_NamiraCannibalismHealRing, Game.GetPlayer())
		Else
			Game.GetPlayer().DoCombatSpellApply(ZRN_NamiraCannibalismHeal, Game.GetPlayer())
		Endif
		Game.EnablePlayerControls()

		Utility.Wait(2)
		ImageSpaceModifier.RemoveCrossFade(2.0)
		ZRN_CannibalFXS.Stop(akCaster)
	ENDIF
EndEvent

Function GrantSkillBoost(Actor PlayerActor)
	Skill01 = GenerateSkill()
	Skill01XP = FindXP(Skill01)
	Float AdvanceSkill01 = Skill01XP/RingCheck()

	Game.AdvanceSkill(Skill01,AdvanceSkill01)
	String SkillName01 = FindName(Skill01)
	Debug.Notification(SkillName01+" skill increased.")
EndFunction

Int Function RingCheck()
	If Game.GetPlayer().IsEquipped(DA11RingofNamira)
		Return 3
	Else
		Return 6
	Endif
EndFunction
;-----------------------------------------------------------------------------------------------------------
; These functions randomly select skills from the options available and provide
; the information on how they should be increased
;-----------------------------------------------------------------------------------------------------------
Float Function FindXP(String SkillString)
	If SkillString == "OneHanded"
		Return 62.38
	ElseIf SkillString == "TwoHanded"
		Return 66.05
	ElseIf SkillString == "Marksman"
		Return 42.25
	ElseIf SkillString == "Block"
		Return 48.52
	ElseIf SkillString == "Smithing"
		Return 393.01
	ElseIf SkillString == "HeavyArmor"
		Return 103.42
	ElseIf SkillString == "LightArmor"
		Return 98.25
	ElseIf SkillString == "Pickpocket"
		Return 48.52
	ElseIf SkillString == "Lockpicking"
		Return 8.73
	ElseIf SkillString == "Sneak"
		Return 34.93
	ElseIf SkillString == "Alchemy"
		Return 524.01
	ElseIf SkillString == "Speechcraft"
		Return 1091.70
	ElseIf SkillString == "Alteration"
		Return 131.00
	ElseIf SkillString == "Conjuration"
		Return 187.14
	ElseIf SkillString == "Destruction"
		Return 291.12
	ElseIf SkillString == "Illusion"
		Return 85.43
	ElseIf SkillString == "Restoration"
		Return 196.50
	ElseIf SkillString == "Enchanting"
		Return 0.43
	EndIf 
EndFunction

String Function FindName(String SkillString)
	If SkillString == "OneHanded"
		Return "One-Handed"
	ElseIf SkillString == "TwoHanded"
		Return "Two-Handed"
	ElseIf SkillString == "Marksman"
		Return "Archery"
	ElseIf SkillString == "HeavyArmor"
		Return "Heavy Armor"
	ElseIf SkillString == "LightArmor"
		Return "Light Armor"
	ElseIf SkillString == "Speechcraft"
		Return "Speech"
	Else
		Return SkillString
	EndIf 
EndFunction

;-----------------------------------------------------------------------------------------------------------
; These functions generate some options for potential skills
;-----------------------------------------------------------------------------------------------------------
String Function GenerateSkill()
	Int[] SkillArray = new Int[18]
	SkillArray[0] = CorpseActor.GetActorValue("TwoHanded") as Int
	SkillArray[1] = CorpseActor.GetActorValue("Alchemy") as Int
	SkillArray[2] = CorpseActor.GetActorValue("Alteration") as Int
	SkillArray[3] = CorpseActor.GetActorValue("Block") as Int
	SkillArray[4] = CorpseActor.GetActorValue("Conjuration") as Int
	SkillArray[5] = CorpseActor.GetActorValue("Destruction") as Int
	SkillArray[6] = CorpseActor.GetActorValue("Enchanting") as Int
	SkillArray[7] = CorpseActor.GetActorValue("HeavyArmor") as Int
	SkillArray[8] = CorpseActor.GetActorValue("Illusion") as Int
	SkillArray[9] = CorpseActor.GetActorValue("LightArmor") as Int
	SkillArray[10] = CorpseActor.GetActorValue("Lockpicking") as Int
	SkillArray[11] = CorpseActor.GetActorValue("Marksman") as Int
	SkillArray[12] = CorpseActor.GetActorValue("OneHanded") as Int
	SkillArray[13] = CorpseActor.GetActorValue("Pickpocket") as Int
	SkillArray[14] = CorpseActor.GetActorValue("Restoration") as Int
	SkillArray[15] = CorpseActor.GetActorValue("Smithing") as Int
	SkillArray[16] = CorpseActor.GetActorValue("Sneak") as Int
	SkillArray[17] = CorpseActor.GetActorValue("Speechcraft") as Int

	String[] SkillNameArray = new String[18]
	SkillNameArray[0] = "TwoHanded"
	SkillNameArray[1] = "Alchemy"
	SkillNameArray[2] = "Alteration"
	SkillNameArray[3] = "Block"
	SkillNameArray[4] = "Conjuration"
	SkillNameArray[5] = "Destruction"
	SkillNameArray[6] = "Enchanting"
	SkillNameArray[7] = "HeavyArmor"
	SkillNameArray[8] = "Illusion"
	SkillNameArray[9] = "LightArmor"
	SkillNameArray[10] = "Lockpicking"
	SkillNameArray[11] = "Marksman"
	SkillNameArray[12] = "OneHanded"
	SkillNameArray[13] = "Pickpocket"
	SkillNameArray[14] = "Restoration"
	SkillNameArray[15] = "Smithing"
	SkillNameArray[16] = "Sneak"
	SkillNameArray[17] = "Speechcraft"

;---------------------------------------------------------
; Here, we figure out the average level
; of all the target's skills.
;---------------------------------------------------------
	Float SkillTotal = 0
	Int ArrayListNumber = (SkillArray.Length - 1)
	While ArrayListNumber >= 0
		SkillTotal = (SkillTotal + SkillArray[ArrayListNumber])
		ArrayListNumber -= 1
	EndWhile
	Float SkillAverage = (SkillTotal/18)
;---------------------------------------------------------
; There's rarely more than 6 skills that are
; above the average.
;---------------------------------------------------------
	String RandomSkill00 = ""
	String RandomSkill01 = ""
	String RandomSkill02 = ""
	String RandomSkill03 = ""
	String RandomSkill04 = ""
	String RandomSkill05 = ""

	ArrayListNumber = (SkillArray.Length - 1)
	While (ArrayListNumber > 0) && (RandomSkill00 == "")
		If SkillArray[ArrayListNumber] >= SkillAverage
			RandomSkill00 = SkillNameArray[ArrayListNumber]
			SkillArray[ArrayListNumber] = 0
		Endif
		ArrayListNumber -= 1
	EndWhile

	ArrayListNumber = (SkillArray.Length - 1)
	While (ArrayListNumber > 0) && (RandomSkill01 == "")
		If SkillArray[ArrayListNumber] >= SkillAverage
			RandomSkill01 = SkillNameArray[ArrayListNumber]
			SkillArray[ArrayListNumber] = 0
		Endif
		ArrayListNumber -= 1
	EndWhile

	ArrayListNumber = (SkillArray.Length - 1)
	While (ArrayListNumber > 0) && (RandomSkill02 == "")
		If SkillArray[ArrayListNumber] >= SkillAverage
			RandomSkill02 = SkillNameArray[ArrayListNumber]
			SkillArray[ArrayListNumber] = 0
		Endif
		ArrayListNumber -= 1
	EndWhile

	ArrayListNumber = (SkillArray.Length - 1)
	While (ArrayListNumber > 0) && (RandomSkill03 == "")
		If SkillArray[ArrayListNumber] >= SkillAverage
			RandomSkill03 = SkillNameArray[ArrayListNumber]
			SkillArray[ArrayListNumber] = 0
		Endif
		ArrayListNumber -= 1
	EndWhile

	ArrayListNumber = (SkillArray.Length - 1)
	While (ArrayListNumber > 0) && (RandomSkill04 == "")
		If SkillArray[ArrayListNumber] >= SkillAverage
			RandomSkill04 = SkillNameArray[ArrayListNumber]
			SkillArray[ArrayListNumber] = 0
		Endif
		ArrayListNumber -= 1
	EndWhile

	ArrayListNumber = (SkillArray.Length - 1)
	While (ArrayListNumber > 0) && (RandomSkill05 == "")
		If SkillArray[ArrayListNumber] >= SkillAverage
			RandomSkill05 = SkillNameArray[ArrayListNumber]
			SkillArray[ArrayListNumber] = 0
		Endif
		ArrayListNumber -= 1
	EndWhile

	Int MaxRandom = 5
	If RandomSkill00 == ""
		MaxRandom -= 1
	EndIf
	If RandomSkill01 == ""
		MaxRandom -= 1
	EndIf
	If RandomSkill02 == ""
		MaxRandom -= 1
	EndIf
	If RandomSkill03 == ""
		MaxRandom -= 1
	EndIf
	If RandomSkill04 == ""
		MaxRandom -= 1
	EndIf
	If RandomSkill05 == ""
		MaxRandom -= 1
	EndIf

	String[] SelectionArray = new String[6]
	SelectionArray[0] = RandomSkill00
	SelectionArray[1] = RandomSkill01
	SelectionArray[2] = RandomSkill02
	SelectionArray[3] = RandomSkill03
	SelectionArray[4] = RandomSkill04
	SelectionArray[5] = RandomSkill05
	If MaxRandom >= 0
		Return SelectionArray[Utility.RandomInt(0,MaxRandom)]
	Else
		Return SkillNameArray[Utility.RandomInt(0,17)]
	Endif
EndFunction