Scriptname ZSM_MagnusRefScript01 extends ReferenceAlias  

Spell Property ZSM_MagnusAbCloak Auto
Weapon Property MG07StaffofMagnus Auto

ReferenceAlias Property MagnusAlias Auto
ReferenceAlias Property OwnerAlias Auto
Actor OwnerActor
Actor NewActor
ObjectReference NewContainer

Function CheckOwner()
	OwnerActor = (OwnerAlias.GetRef() as Actor)
EndFunction

Event OnItemRemoved(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akDestContainer)
NewActor = (akDestContainer as Actor)
NewContainer = (akDestContainer as ObjectReference)

IF (akBaseItem == MG07StaffofMagnus)
	If akDestContainer == None
		MagnusAlias.ForceRefTo(akItemReference)
	Elseif NewActor
		OwnerAlias.ForceRefTo(NewActor)
		If (NewActor.GetEquippedWeapon(True) == MG07StaffofMagnus) ||  (NewActor.GetEquippedWeapon(False) == MG07StaffofMagnus)
			AddCloak(NewActor)
		Endif
	Elseif NewContainer
		OwnerAlias.ForceRefTo(NewContainer)
	Endif
ENDIF
EndEvent

Function AddCloak(Actor akActor)
IF !(akActor.HasSpell(ZSM_MagnusAbCloak))
	akActor.AddSpell(ZSM_MagnusAbCloak, False)
ENDIF
EndFunction

Function RemoveCloak(Actor akActor)
	akActor.RemoveSpell(ZSM_MagnusAbCloak)
EndFunction

Event OnObjectEquipped(Form akBaseObject, ObjectReference akReference)
IF (akBaseObject == MG07StaffofMagnus)
	CheckOwner()
	AddCloak(OwnerActor)
ENDIF
EndEvent

Event OnObjectUnequipped(Form akBaseObject, ObjectReference akReference)
IF (akBaseObject == MG07StaffofMagnus)
	CheckOwner()
	RemoveCloak(OwnerActor)
ENDIF
EndEvent
;--------------------------------------------------------------------------------
;	RESET EVENTS
;--------------------------------------------------------------------------------
Function ResetCloak(Actor akActor)
IF !(akActor == Game.GetPlayer())
	akActor.RemoveSpell(ZSM_MagnusAbCloak)
	Utility.Wait(0.1)
	akActor.AddSpell(ZSM_MagnusAbCloak, False)
ENDIF
EndFunction

Event OnCellAttach()
	ResetCloak(GetRef() as Actor)
EndEvent

Event OnLoad()
	ResetCloak(GetRef() as Actor)
EndEvent

Event OnCombatStateChanged(Actor akTarget, int aeCombatState)
	ResetCloak(GetRef() as Actor)
EndEvent