Scriptname ZWJ_PolymorphObjectScript01 extends activemagiceffect  

;==================================================
; This script is involved in transforming the target into an object, not another actor.
;==================================================

Int Property SpellDuration Auto
Float Property ObjectSize Auto

ObjectReference Property WabbajackHoldingRef Auto

Activator Property PolyObject Auto
Explosion Property ZWJ_Wabbajack_Explosion Auto
Explosion Property ZWJ_Wabbajack_ExplosionLoud Auto
MagicEffect Property ZWJ_Wabbajack_PolymorphLinkSpellEffect Auto
Static Property XMarker Auto

Int Property Rotation Auto
Int Property VerticalPlacement Auto
ObjectReference CreatedObject

Event OnEffectStart (actor akTarget, actor akCaster)
If !(akTarget.HasMagicEffect(ZWJ_Wabbajack_PolymorphLinkSpellEffect))

	ObjectReference PolymorphBeginMarker = akTarget.PlaceAtMe(XMarker)					; Moves the initiating marker to the location of the target
	PolymorphBeginMarker.MoveTo(akTarget,0,0,0,True)
	PolymorphBeginMarker.PlaceAtMe(ZWJ_Wabbajack_ExplosionLoud)							; Creates an explosion
	HoldActor(akTarget)

	CreatedObject = PolymorphBeginMarker.PlaceAtMe(PolyObject)
	Utility.Wait(0.1)
	CreatedObject.SetScale(ObjectSize)

	CreatedObject.Moveto(PolymorphBeginMarker,0,0,VerticalPlacement)						; Creates the object
	If !(Rotation == 0)
		CreatedObject.SetAngle(0, 0, (CreatedObject.GetAngleZ())+Rotation)
	Endif
	PolymorphBeginMarker.Delete()
	Utility.Wait(SpellDuration)

	ObjectReference PolymorphEndMarker = CreatedObject.PlaceAtMe(XMarker)
	PolymorphEndMarker.PlaceAtMe(ZWJ_Wabbajack_ExplosionLoud)					; Creates an explosion at the site of the vegetable
	CreatedObject.Delete()
	ReturnActor(akTarget, PolymorphEndMarker, akCaster)

	akTarget.StartCombat(akCaster)
	PolymorphEndMarker.Delete()
Endif
EndEvent

Function HoldActor(Actor akTarget)
	akTarget.MoveTo(WabbajackHoldingRef)
	akTarget.EnableAI(False)
EndFunction

Function ReturnActor(Actor akTarget, ObjectReference ReturnMarker, Actor akCaster)
	akTarget.EnableAI(True)
	While!(akTarget.GetParentCell() == akCaster.GetParentCell())
		akTarget.MoveTo(ReturnMarker)						
		Utility.Wait(0.1)
	EndWhile
EndFunction