Scriptname ZWJ_PolymorphScript01 extends ActiveMagicEffect

;==================================================
; This script is involved in transforming the target into another actor, not an object.
; This is the initial script that polymorphs a target. PolymorphScript02 runs on the
; new actor as soon as it is created.
;==================================================

ObjectReference Property WabbajackHoldingRef Auto
Explosion Property ZWJ_Wabbajack_Explosion Auto
Static Property XMarker Auto

Spell Property ZWJ_Wabbajack_PolymorphLinkSpell Auto
Spell Property ZWJ_Wabbajack_PolymorphFightSpell Auto
MagicEffect Property ZWJ_Wabbajack_PolymorphLinkSpellEffect Auto

ActorBase Property PolymorphActor Auto

Event OnEffectStart (actor akTarget, actor akCaster)
If !(akTarget.HasMagicEffect(ZWJ_Wabbajack_PolymorphLinkSpellEffect))
	ObjectReference PolymorphBeginMarker = akTarget.PlaceAtMe(XMarker)										; Creates an initiating marker at the location of the target
	PolymorphBeginMarker.PlaceAtMe(ZWJ_Wabbajack_Explosion)												; Creates an explosion

	HoldActor(akTarget)																							; Target immediately disappears

	Actor NewActor = PolymorphBeginMarker.PlaceActorAtMe(PolymorphActor, (Utility.RandomInt(0,2))) as Actor	; Creates the New Actor, which spawns at the initate marker; if it's a levelled actor, it can be anywhere from easy to hard
	akTarget.DoCombatSpellApply(ZWJ_Wabbajack_PolymorphLinkSpell, NewActor)								; Forms the link between the New Actor and the target. This allows the New Actor's death to have an effect on the target (this is handled by a script that's run on the link spell)
	akCaster.DoCombatSpellApply(ZWJ_Wabbajack_PolymorphFightSpell, NewActor)								; Starts a fight between the Wabbajack owner and the new actor
	PolymorphBeginMarker.Delete()

	;Debug.MessageBox(akCaster.GetDisplayName()+" is casting on "+aktarget.GetDisplayName()+" to create "+NewActor.GetDisplayName())
Endif
EndEvent

Function HoldActor(Actor akTarget)
	akTarget.MoveTo(WabbajackHoldingRef)
	akTarget.EnableAI(False)
EndFunction