Scriptname ZWJ_PolymorphScript02 extends activemagiceffect  

;==================================================
; This script is involved in transforming the target into another actor, not an object.
; This is the secondary script that runs on the new actor, not the original actor.
; The effect is cast on the original target actor by the new actor.
;==================================================

Int Property SpellDuration Auto
Actor NewActor
Actor PolymorphedActor

Spell Property ZWJ_Wabbajack_PolymorphLinkSpell Auto
Spell Property ZWJ_Wabbajack_PolymorphFightSpell Auto
Explosion Property ZWJ_Wabbajack_Explosion Auto
Explosion Property ZWJ_Wabbajack_ExplosionLoud Auto
Keyword Property ZWJ_Wabbajack_PolymorphKeyword Auto

ObjectReference PolymorphReturnMarker
Static Property XMarker Auto

Event OnEffectStart (Actor akTarget, Actor akCaster)
	NewActor = akTarget														; The target for this spell is the New Actor identified by the polymorph spell that initiates the link effect
	PolymorphedActor = akCaster												; The caster is the target from the polymorph spell

	SetNewActorHealth()	
	NewActor.BlockActivation(True)												; Prevents the player from accessing the New Actor's inventory
	RegisterForSingleUpdate(SpellDuration)
EndEvent

Function ReturnToNormal(Actor akWabbajack, Explosion ExplosionType)
	If !(PolymorphedActor.IsDead())
		SetPolymorphedActorHealth()
	Endif

	UnregisterForUpdate()
	NewActor.PlaceAtMe(ExplosionType)											; Creates an explosion at the site of the New Actor
	PolymorphReturnMarker = NewActor.PlaceAtMe(XMarker)
	NewActor.Disable()	
	PolymorphedActor.EnableAI(True)
	While!(PolymorphedActor.GetParentCell() == PolymorphReturnMarker.GetParentCell())
		PolymorphedActor.MoveTo(PolymorphReturnMarker)						
		Utility.Wait(0.1)
	EndWhile

	If NewActor.IsDead()
		PolymorphedActor.Kill(akWabbajack)
	Endif

	PolymorphReturnMarker.Delete()														
	NewActor.Delete()
Endfunction


Event OnDeath(Actor akKiller)
	ReturnToNormal(akKiller, ZWJ_Wabbajack_ExplosionLoud)
EndEvent

Event OnUpdate()
	ReturnToNormal(Game.GetPlayer(), ZWJ_Wabbajack_ExplosionLoud)
EndEvent

Event OnMagicEffectApply(ObjectReference akCaster, MagicEffect akEffect)		; The polymorph effect will not work on the New Actors added by polymorph spells. However, the application of new polymorph spells can still be detected...
If akEffect.HasKeyword(ZWJ_Wabbajack_PolymorphKeyword)					; If another polymorph spell is applied to this actor...
	ReturnToNormal(akCaster as Actor, ZWJ_Wabbajack_Explosion)
Endif
EndEvent


Function SetNewActorHealth()
	NewActor.RestoreActorValue("Health", 9999)												; Ensures the new actor is on full health before its new health is calculated
	Float TemplateHealth = PolymorphedActor.GetActorValue("Health") as Float				; Registers the polymorphed actor's health e.g. 50
	Float TemplateBaseHealth = PolymorphedActor.GetBaseActorValue("Health") as Float		; Registers the polymorphed actor base health e.g. 200

	Float HealthPercentage = ((TemplateHealth*100)/TemplateBaseHealth)					; Calculates the percentage of Health the polymorphed actor has  e.g. = 25

	Float ReceiverBaseHealth = NewActor.GetBaseActorValue("Health") as Float				; Calculates the base health of the new actor e.g. 60
	Float NewHealth = ((ReceiverBaseHealth*HealthPercentage)/100) as Float				; Calculates the target health of the new actor based on the percentage e.g. (60*25)/100 = 15
	Float NewHealthDif = (NewActor.GetActorValue("Health") as Float - NewHealth)			; Calculates the damage needed for the target's health, leaving the amount of desired health e.g. 60 - 15 = 45

	Float ActorHealth = NewActor.GetActorValue("Health")									; Calculates the new actor's health
	If ActorHealth <= NewHealthDif															; If the actor's health is less than or equal to the amount of damage about to be infliced....
		NewActor.DamageActorValue("Health", (ActorHealth - 1))								; ...damage the actor's health to 1 to prevent it from spawning dead...
	Else
		NewActor.DamageActorValue("Health", NewHealthDif)								; ...otherwise, damage the actor's health
	Endif
EndFunction

Function SetPolymorphedActorHealth()
	PolymorphedActor.RestoreActorValue("Health", 9999)
	Float TemplateHealth = NewActor.GetActorValue("Health") as Float
	Float TemplateBaseHealth = NewActor.GetBaseActorValue("Health") as Float

	Float HealthPercentage = ((TemplateHealth*100)/TemplateBaseHealth)

	Float ReceiverBaseHealth = PolymorphedActor.GetBaseActorValue("Health") as Float
	Float NewHealth = ((ReceiverBaseHealth*HealthPercentage)/100) as Float	
	Float NewHealthDif = (PolymorphedActor.GetActorValue("Health") as Float - NewHealth)

	Float ActorHealth = PolymorphedActor.GetActorValue("Health")
	If ActorHealth <= NewHealthDif
		PolymorphedActor.DamageActorValue("Health", (ActorHealth - 1))
	Else
		PolymorphedActor.DamageActorValue("Health", NewHealthDif)
	Endif
EndFunction