Scriptname ZWJ_RandomEffectScript01 extends activemagiceffect  

String Property SpellType Auto ; Explosion, Spawn, PushAway, PushUp, PushAround, GhostAb

Explosion Property ExplosionType Auto
ActorBase Property PlaceActor Auto ; Maximum - 5
Int Property ActorCount Auto

Static Property XMarker Auto
Actor TargetActor
Float Property PushStrength Auto
Float Property PushFrequency Auto
Float Property ActorDamage Auto

Explosion Property GhostInExplosion Auto
Explosion Property GhostOutExplosion Auto


Event OnEffectStart(Actor akTarget, Actor akCaster)
IF SpellType == "Explosion"
	akTarget.PlaceAtMe(ExplosionType)
ELSEIF SpellType == "Spawn"
	Int ActorNumber = Utility.RandomInt(1,ActorCount) 
	Actor SpawnActor01 = akTarget.PlaceActorAtMe(PlaceActor) as Actor
	SpawnActor01.PlaceAtMe(GhostInExplosion)
	if ActorNumber >= 2
		Actor SpawnActor02 = akTarget.PlaceActorAtMe(PlaceActor) as Actor
		SpawnActor02.PlaceAtMe(GhostInExplosion)
	endif
	if ActorNumber >= 3
		Actor SpawnActor03 = akTarget.PlaceActorAtMe(PlaceActor) as Actor
		SpawnActor03.PlaceAtMe(GhostInExplosion)
	endif
	if ActorNumber >= 4
		Actor SpawnActor04 = akTarget.PlaceActorAtMe(PlaceActor) as Actor
		SpawnActor04.PlaceAtMe(GhostInExplosion)
	endif
	if ActorNumber == 5
		Actor SpawnActor05 = akTarget.PlaceActorAtMe(PlaceActor) as Actor
		SpawnActor05.PlaceAtMe(GhostInExplosion)
	endif
	if ActorNumber == 6
		Actor SpawnActor06 = akTarget.PlaceActorAtMe(PlaceActor) as Actor
		SpawnActor06.PlaceAtMe(GhostInExplosion)
	endif
	if ActorNumber == 7
		Actor SpawnActor07 = akTarget.PlaceActorAtMe(PlaceActor) as Actor
		SpawnActor07.PlaceAtMe(GhostInExplosion)
	endif
	if ActorNumber == 8
		Actor SpawnActor08 = akTarget.PlaceActorAtMe(PlaceActor) as Actor
		SpawnActor08.PlaceAtMe(GhostInExplosion)
	endif
ELSEIF SpellType == "PushAway"
	akCaster.PushActorAway(akTarget, PushStrength)
	akTarget.DamageAv("Health", ActorDamage)
ELSEIF SpellType == "PushUp"
	ObjectReference PushMarker = akTarget.PlaceAtMe(XMarker) as ObjectReference
	PushMarker.MoveTo(akTarget, 0, 0, -10)
	PushMarker.PushActorAway(akTarget, PushStrength)
	PushMarker.Delete()
	akTarget.DamageAv("Health", ActorDamage)
ELSEIF SpellType == "PushAround"
	TargetActor = akTarget
	PushAround()
ELSEIF SpellType == "GhostAb"
	TargetActor.PlaceAtMe(GhostOutExplosion)
	TargetActor = akTarget
	TargetActor.BlockActivation(True)
	Utility.Wait(8)
	DestroyGhost()
ENDIF
EndEvent

Function PushAround()
	ObjectReference PushMarker = TargetActor.PlaceAtMe(XMarker) as ObjectReference
	PushMarker.MoveTo(TargetActor, (Utility.RandomInt(-350, 350)), (Utility.RandomInt(-350, 350)), (Utility.RandomInt(-350, 350)))
	PushMarker.PushActorAway(TargetActor, PushStrength)
	PushMarker.Delete()
	TargetActor.DamageAv("Health", ActorDamage)
	RegisterForSingleUpdate(PushFrequency)
EndFunction

Event OnUpdate()
	PushAround()
EndEvent

Event OnEffectFinish(Actor akTarget, Actor akCaster)
	UnregisterForUpdate()
EndEvent

Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
IF SpellType == "GhostAb"
	Utility.Wait(0.1)
	If TargetActor.GetActorValue("Health") <= 0
		DestroyGhost()
	Endif
ENDIF
EndEvent

Event OnDeath(Actor akKiller)
IF SpellType == "GhostAb"
DestroyGhost()
ENDIF
EndEvent

Function DestroyGhost()
If ActorCount == 1
TargetActor.PlaceAtMe(GhostOutExplosion)
ActorCount = 0
TargetActor.Delete()
Endif
EndFunction