Scriptname ZWJ_RandomEffectScript02 extends activemagiceffect  

String Property SpellType Auto ; Conjure, ConjureAb, SpawnExplosion

;========================================================
; Conjure Properties
;========================================================
ObjectReference Property WabbajackSummonRef Auto
ActorBase Property EncAtronachFlame Auto
ActorBase Property EncAtronachFrost Auto
ActorBase Property EncAtronachStorm Auto
ActorBase Property LvlDremoraMelee Auto
ActorBase Property LvlDremoraMissile Auto
Activator Property SummonTargetFXActivator Auto
Activator Property EffectSummonBanishFX Auto
ActorBase ConjureActor
;========================================================
; Conjure Ab Properties
;========================================================
Idle Property SpecialIdle Auto
Sound Property SpecialSound Auto
Float Property SpecialDelay Auto
Actor ConjureAbActor
;========================================================
; Explosion Properties
;========================================================
Explosion Property SpawnExplosion Auto
Static Property XMarker Auto
Int Property SpawnQuantity01 Auto
Int Property SpawnQuantity02 Auto
Form SpawnForm01
Form SpawnForm02
MiscObject Property SpawnObject01 Auto
MiscObject Property SpawnObject02 Auto
Potion Property SpawnFood01 Auto
Potion Property SpawnFood02 Auto
Ingredient Property SpawnIngredients01 Auto
Ingredient Property SpawnIngredients02 Auto
SoulGem Property SpawnGem02 Auto

;========================================================
; Events and Functions
;========================================================
Event OnEffectStart(Actor akTarget, Actor akCaster)
IF SpellType == "Conjure"
	Int ActorChoice = Utility.RandomInt(1,5)
	If ActorChoice == 1
		ConjureActor = EncAtronachFlame 
	Elseif ActorChoice == 2
		ConjureActor = EncAtronachFrost
	Elseif ActorChoice == 3
		ConjureActor = EncAtronachStorm
	Elseif ActorChoice == 4
		ConjureActor = LvlDremoraMelee 
	Elseif ActorChoice == 5
		ConjureActor = LvlDremoraMissile 
	Endif
	Actor AtronachActor = akTarget.PlaceAtMe(ConjureActor) as Actor
	AtronachActor.Disable()
	AtronachActor.Enable(True)
	ObjectReference SummonEffect = AtronachActor.PlaceAtMe(SummonTargetFXActivator) as ObjectReference
	AtronachActor.SetAngle(0,0,akTarget.GetAngleZ())
	Utility.Wait(5)
	SummonEffect.Delete()
ELSEIF SpellType == "ConjureAb"
	akTarget.BlockActivation()
	ConjureAbActor = akTarget
	Utility.Wait(0.5)
	If SpecialIdle
		akTarget.PlayIdle(SpecialIdle)
		Utility.Wait(SpecialDelay)
		SpecialSound.Play(akTarget)
	Endif
ELSEIF SpellType == "SpawnExplosion"
	If !(SpawnObject01 == None)
		SpawnForm01 = SpawnObject01
	Elseif !(SpawnFood01 == None)
		SpawnForm01 = SpawnFood01
	Elseif !(SpawnIngredients01 == None)
		SpawnForm01 = SpawnIngredients01
	Else
		SpawnForm01 = None
	Endif
	If !(SpawnObject02 == None)
		SpawnForm02 = SpawnObject02
	Elseif !(SpawnFood02 == None)
		SpawnForm02 = SpawnFood02
	Elseif !(SpawnIngredients02 == None)
		SpawnForm02 = SpawnIngredients02
	Elseif !(SpawnGem02 == None)
		SpawnForm02 = SpawnGem02 
	Else
		SpawnForm02 = None
	Endif
	ObjectReference SpawnMarker = akTarget.PlaceAtMe(XMarker)
	SpawnMarker.MoveTo(akTarget, 0, 0, 50)
	SpawnMarker.PlaceAtMe(SpawnForm01, SpawnQuantity01)
	SpawnMarker.PlaceAtMe(SpawnForm02, SpawnQuantity02)
	akTarget.PlaceAtMe(SpawnExplosion)
	SpawnMarker.Delete()
ENDIF
EndEvent

Event OnCellDetach()
IF SpellType == "ConjureAb"
	ConjureAbActor.Delete()
ENDIF
EndEvent

Event OnDeath(Actor akKiller)
IF SpellType == "ConjureAb"
	ConjureAbActor.BlockActivation(False)
ENDIF
EndEvent