Scriptname ZWJ_RandomEffectScript03 extends ActiveMagicEffect

String Property SpellType Auto ; Immobilize, Instakill
FormList Property DisintegrationMainImmunityList Auto
Activator Property ZWJ_Spell149_InstantKillEffectPile Auto
Bool TargetIsImmune

Explosion Property ZWJ_Wabbajack_Explosion Auto

Event OnEffectStart(Actor akTarget, Actor akCaster)
IF SpellType == "Immobilize"
	akTarget.EnableAI(False)
	akTarget.SetAlpha(0.8)
	akTarget.SetGhost(True)
ELSEIF SpellType == "Instakill"
	ActorBase TargetBase = akTarget.GetBaseObject() as ActorBase
	Race TargetRace = TargetBase.GetRace()
	if !(DisintegrationMainImmunityList.HasForm(TargetRace)) && !(DisintegrationMainImmunityList.HasForm(TargetBase))
		akTarget.PlaceAtMe(ZWJ_Wabbajack_Explosion)
		akTarget.Kill()
		akTarget.SetCriticalStage(akTarget.CritStage_DisintegrateStart)
		akTarget.SetAlpha(0)
			
		akTarget.AttachAshPile(ZWJ_Spell149_InstantKillEffectPile)
		akTarget.SetCriticalStage(akTarget.CritStage_DisintegrateEnd)
	endif
ENDIF
EndEvent

Event OnEffectFinish(Actor akTarget, Actor akCaster)
IF SpellType == "Immobilize"
	akTarget.EnableAI(True)
	akTarget.SetAlpha(1)
	akTarget.SetGhost(False)
ENDIF
EndEvent
