Scriptname ZWJ_WabbajackEffectScript01 extends ActiveMagicEffect  

Int ChaosNumber
Spell ChaosSpell

Keyword Property ActorTypeDragon Auto
Keyword Property ActorTypeDaedra Auto
Keyword Property ActorTypeDwarven Auto
Keyword Property ZWJ_Wabbajack_PolymorphImmuneKeyword Auto

MagicEffect Property ZWJ_Wabbajack_PolymorphLinkSpellEffect Auto

FormList Property ZWJ_FullList Auto ;			Positive, negative and polymorph effects
FormList Property ZWJ_EssentialList Auto	; 		Postive and negative effects only
FormList Property ZWJ_DragonFlightList Auto ;	Specific dragon-friendly effects
FormList Property ZWJ_TestList Auto ;			For testing
FormList CurrentFormlist


Event OnEffectStart (Actor akTarget, Actor akCaster)
IF !(akTarget.IsDead())
IF !(akTarget.HasKeyword(ZWJ_Wabbajack_PolymorphImmuneKeyword))
	If (akTarget.HasKeyword(ActorTypeDragon)) && (akTarget.IsFlying())
		CurrentFormList = ZWJ_DragonFlightList		
		;Debug.MessageBox("Dragon List")	
	Elseif akTarget == Game.GetPlayer() || akTarget.IsEssential() || akTarget.HasKeyword(ActorTypeDwarven) || akTarget.HasKeyword(ActorTypeDaedra) || akTarget.HasKeyword(ActorTypeDragon) || akTarget.HasMagicEffect(ZWJ_Wabbajack_PolymorphLinkSpellEffect) 	; The first step is to decide what effects the Wabbajack can cause. The player, essential targets, automatons and dragons can only recieve positive or negative effects (no polymorphs)
		CurrentFormList = ZWJ_EssentialList		
		;Debug.MessageBox("Essential List")											
	Else																																	; if the target isn't the player, essential, an automaton or a dragon, anything can go, so the script is extended to include all formlists
		CurrentFormList = ZWJ_FullList
		;Debug.MessageBox("Full List")	
	Endif

	;CurrentFormList = ZWJ_TestList 

	Int FormListSize = (CurrentFormList.GetSize() - 1) as Int				; Once the formlist has been selected, the size of that list is registered. One is subtracted because the highest value in the list is one lower than the total number of items (because the lowest value is 0, not 1)													
	;Debug.MessageBox("The size of the list is "+FormListSize)
	ChaosNumber = Utility.RandomInt(0, FormListSize) as Int				; Once the size is registered, a random number is generated between 1 and the size of the formlist. This ensures no numbers are generated that are higher than the number of spells in the form list
	;Debug.MessageBox("The chosen number is "+ChaosNumber)

	ChaosSpell = CurrentFormList.GetAt(ChaosNumber) as Spell			; The spell is selected from the formlist at the position specified by the random number that has been generated
	akCaster.DoCombatSpellApply(ChaosSpell, akTarget)					; The selected spell effect is applied to the Target from the Caster
ENDIF
ENDIF
EndEvent