function AirProducer:CreateLifeSupportElements()
  if self.air_production < 40000 then
	self.air_production = 40000
  end
  self.air = NewSupplyGridProducer(self)
  self.air:SetProduction(self.working and self.air_production or 0)
end

function WaterProducer:CreateLifeSupportElements()
  if self.water_production < 30000 then
	self.water_production = 30000
  end
  self.water = NewSupplyGridProducer(self)
  self.water:SetProduction(self.working and self.water_production or 0)
end

ElectricityStorage.properties = {
    {
      template = true,
      id = "max_electricity_charge",
      name = T({
        938,
        "Max consumption while charging"
      }),
      category = "Power Storage",
      editor = "number",
      default = 10000,
      help = "This is the amount of electricity the battery can charge per hour.",
      modifiable = true
    },
    {
      template = true,
      id = "max_electricity_discharge",
      name = T({
        939,
        "Max output while discharging"
      }),
      category = "Power Storage",
      editor = "number",
      default = 10000,
      help = "This is the amount of electricity the battery can discharge per hour.",
      modifiable = true
    },
    {
      template = true,
      id = "conversion_efficiency",
      name = T({
        940,
        "Conversion efficiency % (charging)"
      }),
      category = "Power Storage",
      editor = "number",
      default = 90,
      help = "(100 - this number)% will go to waste when charging.",
      modifiable = true
    },
    {
      template = true,
      id = "capacity",
      name = T({
        941,
        "Capacity (watts*hour)"
      }),
      editor = "number",
      category = "Power Storage",
      default = 10000,
      modifiable = true
    },
    {
      template = true,
      id = "charge_animation",
      name = T({
        942,
        "Change animation"
      }),
      editor = "combo",
      default = "none",
      items = function(obj)
        return GetEntityStatesForTemplateObj(obj, true)
      end,
      category = "Power Storage",
      help = "If not none will play said animation, where the start of the anim will be when charge == 0 and the end of the anim will be when charge is 100%."
    },
    {
      template = true,
      id = "empty_state",
      name = T({
        943,
        "Empty state"
      }),
      editor = "combo",
      default = "none",
      items = function(obj)
        return GetEntityStatesForTemplateObj(obj, true)
      end,
      category = "Power Storage",
      help = "If charge anim is none this is ignored. Will set said state when storage == 0 and no anim is playing."
    },
    {
      template = true,
      id = "full_state",
      name = T({944, "Full state"}),
      editor = "combo",
      default = "none",
      items = function(obj)
        return GetEntityStatesForTemplateObj(obj, true)
      end,
      category = "Power Storage",
      help = "If charge anim is none this is ignored. Will set said state when storage == 100% and no anim is playing."
    },
    {
      id = "StoredPower",
      name = T({
        945,
        "Stored Power"
      }),
      editor = "number",
      default = 0,
      scale = const.ResourceScale,
      no_edit = true
    }
  }

WaterStorage.properties = {
    {
      template = true,
      id = "max_water_charge",
      name = T({
        29,
        "Max water consumption while charging"
      }),
      category = "Storage",
      editor = "number",
      default = 100000,
      help = "This is the amount of water the battery can charge per hour.",
      scale = const.ResourceScale,
      modifiable = true
    },
    {
      template = true,
      id = "max_water_discharge",
      name = T({
        1068,
        "Max water output while discharging"
      }),
      category = "Storage",
      editor = "number",
      default = 100000,
      help = "This is the amount of air the battery can discharge per hour.",
      scale = const.ResourceScale,
      modifiable = true
    },
    {
      template = true,
      id = "water_conversion_efficiency",
      name = T({
        1069,
        "Conversion efficiency % of water (charging)"
      }),
      category = "Storage",
      editor = "number",
      default = 100,
      help = "(100 - this number)% will go to waste when charging."
    },
    {
      template = true,
      id = "water_capacity",
      name = T({
        30,
        "Water Capacity"
      }),
      editor = "number",
      category = "Storage",
      default = 10000,
      scale = const.ResourceScale,
      modifiable = true
    },
    {
      id = "StoredWater",
      name = T({
        33,
        "Stored Water"
      }),
      editor = "number",
      default = 0,
      scale = const.ResourceScale,
      no_edit = true
    }
  }
AirStorage.properties = {
    {
      template = true,
      id = "max_air_charge",
      name = T({
        1070,
        "Max Oxygen consumption while charging"
      }),
      category = "Storage",
      editor = "number",
      default = 100000,
      help = "This is the amount of Oxygen the battery can charge per hour.",
      scale = const.ResourceScale,
      modifiable = true
    },
    {
      template = true,
      id = "max_air_discharge",
      name = T({
        1071,
        "Max Oxygen output while discharging"
      }),
      category = "Storage",
      editor = "number",
      default = 100000,
      help = "This is the amount of Oxygen the battery can discharge per hour.",
      scale = const.ResourceScale,
      modifiable = true
    },
    {
      template = true,
      id = "air_conversion_efficiency",
      name = T({
        1072,
        "Conversion Oxygen efficiency % (charging)"
      }),
      category = "Storage",
      editor = "number",
      default = 100,
      help = "(100 - this number)% will go to waste when charging."
    },
    {
      template = true,
      id = "air_capacity",
      name = T({
        1073,
        "Oxygen Capacity"
      }),
      editor = "number",
      category = "Storage",
      default = 10000,
      scale = const.ResourceScale,
      modifiable = true
    },
    {
      id = "StoredAir",
      name = T({1074, "Stored Air"}),
      editor = "number",
      default = 0,
      scale = const.ResourceScale,
      no_edit = true
    }
  }