
local function ReTune(times)
	
	if times == nil then
		print("times isn't initialized.")
		times = 1
	else
		print("set day time speed "..times.." times slower.")
	end
	
	if overrides == nil then
		overrides = {}
	end
	
	local seg_time = 30  * times
	local total_day_time = seg_time*16
	
	local day_segs = 10
	local dusk_segs = 4
	local night_segs = 2
	
	--default day composition. changes in winter, etc
	local day_time = seg_time * day_segs
	local dusk_time = seg_time * dusk_segs
	local night_time = seg_time * night_segs
	
	local wilson_attack = 34
	local wilson_health = 150
	local calories_per_day = 75
	
	local wilson_attack_period = .5
	-----------------------
	
	local perish_warp = 1--/200
	
	TUNING.DEMO_TIME = total_day_time * 2 + day_time*.2;
	TUNING.AUTOSAVE_INTERVAL = total_day_time;
	TUNING.SEG_TIME = seg_time;
	TUNING.TOTAL_DAY_TIME = total_day_time;
	TUNING.DAY_SEGS_DEFAULT = day_segs;
	TUNING.DUSK_SEGS_DEFAULT = dusk_segs;
	TUNING.NIGHT_SEGS_DEFAULT = night_segs;

	TUNING.STACK_SIZE_LARGEITEM = 10;
	TUNING.STACK_SIZE_MEDITEM = 20;
	TUNING.STACK_SIZE_SMALLITEM = 40;

	TUNING.GOLDENTOOLFACTOR = 4;

	TUNING.DARK_CUTOFF = 0;
	TUNING.DARK_SPAWNCUTOFF = 0.1;
	TUNING.WILSON_HEALTH = wilson_health;
	TUNING.WILSON_ATTACK_PERIOD = .5;
	TUNING.WILSON_HUNGER = 150; --stomach size
	TUNING.WILSON_HUNGER_RATE = calories_per_day/total_day_time; --calories burnt per day

	TUNING.WX78_MIN_HEALTH = 100;
	TUNING.WX78_MIN_HUNGER = 100;
	TUNING.WX78_MIN_SANITY = 100;

	TUNING.WX78_MAX_HEALTH = 400;
	TUNING.WX78_MAX_HUNGER = 200;
	TUNING.WX78_MAX_SANITY = 300;

	TUNING.WILSON_SANITY = 200;
	TUNING.WILLOW_SANITY = 120;

	TUNING.HAMMER_LOOT_PERCENT = .5;
	TUNING.AXE_USES = 100;
	TUNING.HAMMER_USES = 75;
	TUNING.SHOVEL_USES = 25;
	TUNING.PITCHFORK_USES = 25;
	TUNING.PICKAXE_USES = 33;
	TUNING.BUGNET_USES = 10;
	TUNING.SPEAR_USES = 150;
	TUNING.SPIKE_USES = 100;
	TUNING.FISHINGROD_USES = 9;
	TUNING.TRAP_USES = 8;
	TUNING.BOOMERANG_USES = 10;
	TUNING.BOOMERANG_DISTANCE = 12;
	TUNING.NIGHTSWORD_USES = 100;
	TUNING.ICESTAFF_USES = 20;
	TUNING.FIRESTAFF_USES = 20;
	TUNING.TELESTAFF_USES = 5;
	TUNING.HAMBAT_USES = 100;
	TUNING.BATBAT_USES = 75;
	TUNING.MULTITOOL_AXE_PICKAXE_USES = 400;
	TUNING.RUINS_BAT_USES = 150;


	TUNING.REDAMULET_USES = 20;
	TUNING.REDAMULET_CONVERSION = 5;

	TUNING.BLUEAMULET_FUEL = total_day_time * 0.75;
	TUNING.BLUEGEM_COOLER = -20;

	TUNING.PURPLEAMULET_FUEL = total_day_time * 0.4;

	TUNING.YELLOWAMULET_FUEL = total_day_time;
	TUNING.YELLOWSTAFF_USES = 20;

	TUNING.ORANGEAMULET_USES = 225;
	TUNING.ORANGEAMULET_RANGE = 4;
	TUNING.ORANGEAMULET_ICD = 0.33;
	TUNING.ORANGESTAFF_USES = 20;

	TUNING.GREENAMULET_USES = 5;
	TUNING.GREENAMULET_INGREDIENTMOD = 0.5;
	TUNING.GREENSTAFF_USES = 5;


	TUNING.FISHING_MINWAIT = 2;
	TUNING.FISHING_MAXWAIT = 20;

	TUNING.RESEARCH_MACHINE_DIST = 4;

	TUNING.UNARMED_DAMAGE = 10;
	TUNING.NIGHTSWORD_DAMAGE = wilson_attack*2;
	-------
	TUNING.BATBAT_DAMAGE = wilson_attack * 1.25;
	TUNING.BATBAT_DRAIN = wilson_attack * 0.2;
	-------
	TUNING.SPIKE_DAMAGE = wilson_attack*1.5;
	TUNING.HAMBAT_DAMAGE = wilson_attack*1.75;
	TUNING.SPEAR_DAMAGE = wilson_attack;
	TUNING.AXE_DAMAGE = wilson_attack*.8;
	TUNING.PICK_DAMAGE = wilson_attack*.8;
	TUNING.BOOMERANG_DAMAGE = wilson_attack*.8;
	TUNING.TORCH_DAMAGE = wilson_attack*.5;
	TUNING.HAMMER_DAMAGE = wilson_attack*.5;
	TUNING.SHOVEL_DAMAGE = wilson_attack*.5;
	TUNING.PITCHFORK_DAMAGE = wilson_attack*.5;
	TUNING.BUGNET_DAMAGE = wilson_attack*.125;
	TUNING.FISHINGROD_DAMAGE = wilson_attack*.125;
	TUNING.UMBRELLA_DAMAGE = wilson_attack*.5;
	TUNING.CANE_DAMAGE = wilson_attack*.5;
	TUNING.BEAVER_DAMAGE = wilson_attack*1.5;
	TUNING.MULTITOOL_DAMAGE = wilson_attack*.9;
	TUNING.RUINS_BAT_DAMAGE = wilson_attack * 1.75;

	TUNING.CANE_SPEED_MULT = 1.25;
	TUNING.PIGGYBACK_SPEED_MULT = 0.8;
	TUNING.RUINS_BAT_SPEED_MULT = 1.1;

	TUNING.TORCH_ATTACK_IGNITE_PERCENT = 1;

	TUNING.PIG_DAMAGE = 33;
	TUNING.PIG_HEALTH = 250;
	TUNING.PIG_ATTACK_PERIOD = 3;
	TUNING.PIG_TARGET_DIST = 16;
	TUNING.PIG_LOYALTY_MAXTIME = 2.5*total_day_time;
	TUNING.PIG_LOYALTY_PER_HUNGER = total_day_time/25;
	TUNING.PIG_MIN_POOP_PERIOD = seg_time * .5;

	TUNING.WEREPIG_DAMAGE = 40;
	TUNING.WEREPIG_HEALTH = 350;
	TUNING.WEREPIG_ATTACK_PERIOD = 2;

	TUNING.PIG_GUARD_DAMAGE = 33;
	TUNING.PIG_GUARD_HEALTH = 300;
	TUNING.PIG_GUARD_ATTACK_PERIOD = 1.5;
	TUNING.PIG_GUARD_TARGET_DIST = 8;
	TUNING.PIG_GUARD_DEFEND_DIST = 20;

	TUNING.PIG_RUN_SPEED = 5;
	TUNING.PIG_WALK_SPEED = 3;

	TUNING.WEREPIG_RUN_SPEED = 7;
	TUNING.WEREPIG_WALK_SPEED = 3;

	TUNING.WILSON_WALK_SPEED = 4;
	TUNING.WILSON_RUN_SPEED = 6;

	TUNING.PERD_SPAWNCHANCE = 0.1;
	TUNING.PERD_DAMAGE = 20;
	TUNING.PERD_HEALTH = 50;
	TUNING.PERD_ATTACK_PERIOD = 3;
	TUNING.PERD_RUN_SPEED = 8;
	TUNING.PERD_WALK_SPEED = 3;

	TUNING.MERM_DAMAGE = 30;
	TUNING.MERM_HEALTH = 250;
	TUNING.MERM_ATTACK_PERIOD = 3;
	TUNING.MERM_RUN_SPEED = 8;
	TUNING.MERM_WALK_SPEED = 3;
	TUNING.MERM_TARGET_DIST = 10;
	TUNING.MERM_DEFEND_DIST = 30;

	TUNING.WALRUS_DAMAGE = 33;
	TUNING.WALRUS_HEALTH = 150;
	TUNING.WALRUS_ATTACK_PERIOD = 3;
	TUNING.WALRUS_ATTACK_DIST = 15;
	TUNING.WALRUS_DART_RANGE = 25;
	TUNING.WALRUS_MELEE_RANGE = 5;
	TUNING.WALRUS_TARGET_DIST = 10;
	TUNING.WALRUS_LOSETARGET_DIST = 30;
	TUNING.WALRUS_REGEN_PERIOD = total_day_time*2.5;

	TUNING.LITTLE_WALRUS_DAMAGE = 22;
	TUNING.LITTLE_WALRUS_HEALTH = 100;
	TUNING.LITTLE_WALRUS_ATTACK_PERIOD = 3 * 1.7;
	TUNING.LITTLE_WALRUS_ATTACK_DIST = 15;

	TUNING.PIPE_DART_DAMAGE = 100;

	TUNING.PENGUIN_DAMAGE = 33;
	TUNING.PENGUIN_HEALTH = 150;
	TUNING.PENGUIN_ATTACK_PERIOD = 3;
	TUNING.PENGUIN_ATTACK_DIST = 2.5;
	TUNING.PENGUIN_MATING_SEASON_LENGTH = 6;
	TUNING.PENGUIN_MATING_SEASON_WAIT = 1;
	TUNING.PENGUIN_MATING_SEASON_BABYDELAY = total_day_time*1.5;
	TUNING.PENGUIN_MATING_SEASON_BABYDELAY_VARIANCE = 0.5*total_day_time;
	TUNING.PENGUIN_TARGET_DIST = 15;
	TUNING.PENGUIN_CHASE_DIST = 30;
	TUNING.PENGUIN_FOLLOW_TIME = 10;
	TUNING.PENGUIN_HUNGER = total_day_time * 12;  -- takes all winter to starve
	TUNING.PENGUIN_STARVE_TIME = total_day_time * 12;
	TUNING.PENGUIN_STARVE_KILL_TIME = 20;

	TUNING.KNIGHT_DAMAGE = 40;
	TUNING.KNIGHT_HEALTH = 300;
	TUNING.KNIGHT_ATTACK_PERIOD = 2;
	TUNING.KNIGHT_WALK_SPEED = 5;
	TUNING.KNIGHT_TARGET_DIST = 10;

	TUNING.BISHOP_DAMAGE = 40;
	TUNING.BISHOP_HEALTH = 300;
	TUNING.BISHOP_ATTACK_PERIOD = 4;
	TUNING.BISHOP_ATTACK_DIST = 6;
	TUNING.BISHOP_WALK_SPEED = 5;
	TUNING.BISHOP_TARGET_DIST = 12;

	TUNING.ROOK_DAMAGE = 45;
	TUNING.ROOK_HEALTH = 300;
	TUNING.ROOK_ATTACK_PERIOD = 2;
	TUNING.ROOK_WALK_SPEED = 5;
	TUNING.ROOK_RUN_SPEED = 16;
	TUNING.ROOK_TARGET_DIST = 12;

	TUNING.MINOTAUR_DAMAGE = 100;
	TUNING.MINOTAUR_HEALTH = 2500;
	TUNING.MINOTAUR_ATTACK_PERIOD = 2;
	TUNING.MINOTAUR_WALK_SPEED = 5;
	TUNING.MINOTAUR_RUN_SPEED = 17;
	TUNING.MINOTAUR_TARGET_DIST = 25;

	TUNING.SLURTLE_DAMAGE = 25;
	TUNING.SLURTLE_HEALTH = 600;
	TUNING.SLURTLE_ATTACK_PERIOD = 4;
	TUNING.SLURTLE_ATTACK_DIST = 2.5;
	TUNING.SLURTLE_WALK_SPEED = 3;
	TUNING.SLURTLE_TARGET_DIST = 10;
	TUNING.SLURTLE_SHELL_ABSORB = 0.95;
	TUNING.SLURTLE_DAMAGE_UNTIL_SHIELD = 150;

	TUNING.SLURTLE_EXPLODE_DAMAGE = 300;
	TUNING.SLURTLESLIME_EXPLODE_DAMAGE = 50;

	TUNING.SNURTLE_WALK_SPEED = 4;
	TUNING.SNURTLE_DAMAGE = 5;
	TUNING.SNURTLE_HEALTH = 200;
	TUNING.SNURTLE_SHELL_ABSORB = 0.8;
	TUNING.SNURTLE_DAMAGE_UNTIL_SHIELD = 10;
	TUNING.SNURTLE_EXPLODE_DAMAGE = 300;

	TUNING.LIGHTNING_DAMAGE = 20;

	TUNING.FREEZING_KILL_TIME = 120;
	TUNING.STARVE_KILL_TIME = 120;
	TUNING.HUNGRY_THRESH = .333;

	TUNING.GRUEDAMAGE = wilson_health*.667;

	TUNING.MARSHBUSH_DAMAGE = wilson_health*.02;

	TUNING.GHOST_SPEED = 2;
	TUNING.GHOST_HEALTH = 200;
	TUNING.GHOST_RADIUS = 1.5;
	TUNING.GHOST_DAMAGE = wilson_health*0.1;
	TUNING.GHOST_DMG_PERIOD = 1.2;
	TUNING.GHOST_DMG_PLAYER_PERCENT = 1;

	TUNING.ABIGAIL_SPEED = 5;
	TUNING.ABIGAIL_HEALTH = wilson_health*4;
	TUNING.ABIGAIL_DAMAGE_PER_SECOND = 20;
	TUNING.ABIGAIL_DMG_PERIOD = 1.5;
	TUNING.ABIGAIL_DMG_PLAYER_PERCENT = 0.25;

	TUNING.EVERGREEN_GROW_TIME =
	{
		{base=1.5*day_time, random=0.5*day_time},   --short
		{base=5*day_time, random=2*day_time},   --normal
		{base=5*day_time, random=2*day_time},   --tall
		{base=1*day_time, random=0.5*day_time}   --old
	};

	TUNING.PINECONE_GROWTIME = {base=0.75*day_time, random=0.25*day_time};

	TUNING.EVERGREEN_CHOPS_SMALL = 5;
	TUNING.EVERGREEN_CHOPS_NORMAL = 10;
	TUNING.EVERGREEN_CHOPS_TALL = 15;

	TUNING.MUSHTREE_CHOPS_SMALL = 10;
	TUNING.MUSHTREE_CHOPS_MEDIUM = 10;
	TUNING.MUSHTREE_CHOPS_TALL = 15;

	TUNING.ROCKS_MINE = 6;
	TUNING.ROCKS_MINE_MED = 4;
	TUNING.ROCKS_MINE_LOW = 2;
	TUNING.SPILAGMITE_SPAWNER = 2;
	TUNING.SPILAGMITE_ROCK = 4;
	TUNING.MARBLEPILLAR_MINE = 10;
	TUNING.MARBLETREE_MINE = 8;

	TUNING.BEEFALO_HEALTH = 500;
	TUNING.BEEFALO_DAMAGE = 34;
	TUNING.BEEFALO_MATING_SEASON_LENGTH = 3;
	TUNING.BEEFALO_MATING_SEASON_WAIT = 12;
	TUNING.BEEFALO_MATING_SEASON_BABYDELAY = total_day_time*1.5;
	TUNING.BEEFALO_MATING_SEASON_BABYDELAY_VARIANCE = 0.5*total_day_time;
	TUNING.BEEFALO_TARGET_DIST = 5;
	TUNING.BEEFALO_CHASE_DIST = 30;
	TUNING.BEEFALO_FOLLOW_TIME = 30;
	TUNING.BEEFALOHERD_RANGE = 40;
	TUNING.BEEFALOHERD_MAX_IN_RANGE = 16;

	TUNING.BABYBEEFALO_HEALTH = 300;
	TUNING.BABYBEEFALO_GROW_TIME = {base=3*day_time, random=2*day_time};

	TUNING.KOALEFANT_HEALTH = 500;
	TUNING.KOALEFANT_DAMAGE = 50;
	TUNING.KOALEFANT_TARGET_DIST = 5;
	TUNING.KOALEFANT_CHASE_DIST = 30;
	TUNING.KOALEFANT_FOLLOW_TIME = 30;

	TUNING.HUNT_SPAWN_DIST = 40;
	TUNING.HUNT_COOLDOWN = total_day_time*1.2;
	TUNING.HUNT_COOLDOWNDEVIATION = total_day_time*.3;

	TUNING.HUNT_RESET_TIME = 5;
	TUNING.HUNT_SPRING_RESET_TIME = total_day_time * 3;

	TUNING.TRACK_ANGLE_DEVIATION = 30;
	TUNING.MIN_HUNT_DISTANCE = 300; -- you can't find a new beast without being at least this far from the last one
	TUNING.MAX_DIRT_DISTANCE = 200; -- if you get this far away from your dirt pile, you probably aren't going to see it any time soon, so remove it and place a new one

	TUNING.BAT_DAMAGE = 20;
	TUNING.BAT_HEALTH = 50;
	TUNING.BAT_ATTACK_PERIOD = 1;
	TUNING.BAT_ATTACK_DIST = 1.5;
	TUNING.BAT_WALK_SPEED = 8;
	TUNING.BAT_TARGET_DIST = 12;

	TUNING.SPIDER_HEALTH = 100;
	TUNING.SPIDER_DAMAGE = 20;
	TUNING.SPIDER_ATTACK_PERIOD = 3;
	TUNING.SPIDER_TARGET_DIST = 4;
	TUNING.SPIDER_INVESTIGATETARGET_DIST = 6;
	TUNING.SPIDER_WAKE_RADIUS = 4;
	TUNING.SPIDER_FLAMMABILITY = .33;
	TUNING.SPIDER_SUMMON_WARRIORS_RADIUS = 12;

	TUNING.SPIDER_WALK_SPEED = 3;
	TUNING.SPIDER_RUN_SPEED = 5;

	TUNING.SPIDER_WARRIOR_HEALTH = 200;
	TUNING.SPIDER_WARRIOR_DAMAGE = 20;
	TUNING.SPIDER_WARRIOR_ATTACK_PERIOD = 4;
	TUNING.SPIDER_WARRIOR_ATTACK_RANGE = 6;
	TUNING.SPIDER_WARRIOR_HIT_RANGE = 3;
	TUNING.SPIDER_WARRIOR_MELEE_RANGE = 3;
	TUNING.SPIDER_WARRIOR_TARGET_DIST = 10;
	TUNING.SPIDER_WARRIOR_WAKE_RADIUS = 6;

	TUNING.SPIDER_WARRIOR_WALK_SPEED = 4;
	TUNING.SPIDER_WARRIOR_RUN_SPEED = 5;

	TUNING.SPIDER_HIDER_HEALTH = 150;
	TUNING.SPIDER_HIDER_DAMAGE = 20;
	TUNING.SPIDER_HIDER_ATTACK_PERIOD = 3;
	TUNING.SPIDER_HIDER_WALK_SPEED = 3;
	TUNING.SPIDER_HIDER_RUN_SPEED = 5;
	TUNING.SPIDER_HIDER_SHELL_ABSORB = 0.75;

	TUNING.SPIDER_SPITTER_HEALTH = 175;
	TUNING.SPIDER_SPITTER_DAMAGE_MELEE = 20;
	TUNING.SPIDER_SPITTER_DAMAGE_RANGED = 20;
	TUNING.SPIDER_SPITTER_ATTACK_PERIOD = 5;
	TUNING.SPIDER_SPITTER_ATTACK_RANGE = 5;
	TUNING.SPIDER_SPITTER_MELEE_RANGE = 2;
	TUNING.SPIDER_SPITTER_HIT_RANGE = 3;
	TUNING.SPIDER_SPITTER_WALK_SPEED = 4;
	TUNING.SPIDER_SPITTER_RUN_SPEED = 5;

	TUNING.LEIF_HEALTH = 2000;
	TUNING.LEIF_DAMAGE = 150;
	TUNING.LEIF_ATTACK_PERIOD = 3;
	TUNING.LEIF_FLAMMABILITY = .333;

	TUNING.LEIF_MIN_DAY = 3;
	TUNING.LEIF_PERCENT_CHANCE = 1/75;
	TUNING.LEIF_MAXSPAWNDIST = 15;

	TUNING.LEIF_PINECONE_CHILL_CHANCE_CLOSE = .33;
	TUNING.LEIF_PINECONE_CHILL_CHANCE_FAR = .15;
	TUNING.LEIF_PINECONE_CHILL_CLOSE_RADIUS = 5;
	TUNING.LEIF_PINECONE_CHILL_RADIUS = 16;
	TUNING.LEIF_REAWAKEN_RADIUS = 20;

	TUNING.LEIF_BURN_TIME = 10;
	TUNING.LEIF_BURN_DAMAGE_PERCENT = 1/8;

	TUNING.DEERCLOPS_HEALTH = 2000;
	TUNING.DEERCLOPS_DAMAGE = 150;
	TUNING.DEERCLOPS_ATTACK_PERIOD = 3;

	TUNING.BIRD_SPAWN_MAX = 4;
	TUNING.BIRD_SPAWN_DELAY = {min=5, max=15};
	TUNING.BIRD_SPAWN_MAX_FEATHERHAT = 7;
	TUNING.BIRD_SPAWN_DELAY_FEATHERHAT = {min=2, max=10};

	TUNING.FROG_RAIN_DELAY = {min=0.1, max=2};
	TUNING.FROG_RAIN_SPAWN_RADIUS = 60;
	TUNING.FROG_RAIN_MAX = 300;
	TUNING.FROG_RAIN_LOCAL_MAX = 25;
	TUNING.FROG_RAIN_MAX_RADIUS = 50;
	TUNING.FROG_RAIN_PRECIPITATION = 0.8; -- 0-1, 0.8 by default (old "often" setting for Adventure)
	TUNING.FROG_RAIN_MOISTURE = 2500; -- 0-4000ish, 2500 by default (old "often" setting for Adventure)
	TUNING.SURVIVAL_FROG_RAIN_PRECIPITATION = 0.67;
	TUNING.FROG_RAIN_CHANCE = .16;

	TUNING.BEE_HEALTH = 100;
	TUNING.BEE_DAMAGE = 10;
	TUNING.BEE_ATTACK_PERIOD = 2;
	TUNING.BEE_TARGET_DIST = 8;

	TUNING.BEEMINE_BEES = 4;
	TUNING.BEEMINE_RADIUS = 3;

	TUNING.SPIDERDEN_GROW_TIME = {day_time*8, day_time*8, day_time*20};
	TUNING.SPIDERDEN_HEALTH = {50*5, 50*10, 50*20};
	TUNING.SPIDERDEN_SPIDERS = {3, 6, 9};
	TUNING.SPIDERDEN_WARRIORS = {0, 1, 3};  -- every hit, release up to this many warriors, and fill remainder with regular spiders
	TUNING.SPIDERDEN_SPIDER_TYPE = {"spider", "spider_warrior", "spider_warrior"};
	TUNING.SPIDERDEN_REGEN_TIME = 3*seg_time;
	TUNING.SPIDERDEN_RELEASE_TIME = 5;

	TUNING.HOUNDMOUND_HOUNDS = 3;
	TUNING.HOUNDMOUND_REGEN_TIME = seg_time;
	TUNING.HOUNDMOUND_RELEASE_TIME = 5;

	TUNING.POND_FROGS = 4;
	TUNING.POND_REGEN_TIME = day_time/2;
	TUNING.POND_SPAWN_TIME = day_time/4;
	TUNING.POND_RETURN_TIME = day_time*3/4;
	TUNING.FISH_RESPAWN_TIME = day_time/3;

	TUNING.BEEHIVE_BEES = 6;
	TUNING.BEEHIVE_RELEASE_TIME = day_time/6;
	TUNING.BEEHIVE_REGEN_TIME = seg_time;
	TUNING.BEEBOX_BEES = 4;
	TUNING.WASPHIVE_WASPS = 6;
	TUNING.BEEBOX_RELEASE_TIME = (0.5*day_time)/4;
	TUNING.BEEBOX_HONEY_TIME = day_time;
	TUNING.BEEBOX_REGEN_TIME = seg_time*4;

	TUNING.WORM_DAMAGE = 75;
	TUNING.WORM_ATTACK_PERIOD = 4;
	TUNING.WORM_ATTACK_DIST = 3;
	TUNING.WORM_HEALTH = 900;
	TUNING.WORM_CHASE_TIME = 20;
	TUNING.WORM_LURE_TIME = 20;
	TUNING.WORM_LURE_VARIANCE = 10;
	TUNING.WORM_FOOD_DIST = 15;
	TUNING.WORM_CHASE_DIST = 50;
	TUNING.WORM_WANDER_DIST = 30;
	TUNING.WORM_TARGET_DIST = 20;
	TUNING.WORM_LURE_COOLDOWN = 30;
	TUNING.WORM_EATING_COOLDOWN = 30;

	TUNING.WORMLIGHT_RADIUS = 3;
	TUNING.WORMLIGHT_DURATION = 90;

	TUNING.TENTACLE_DAMAGE = 34;
	TUNING.TENTACLE_ATTACK_PERIOD = 2;
	TUNING.TENTACLE_ATTACK_DIST = 4;
	TUNING.TENTACLE_STOPATTACK_DIST = 6;
	TUNING.TENTACLE_HEALTH = 500;

	TUNING.TENTACLE_PILLAR_HEALTH = 500;
	TUNING.TENTACLE_PILLAR_ARMS = 12;   -- max spawned at a time
	TUNING.TENTACLE_PILLAR_ARMS_TOTAL = 25;  -- max simultaneous arms
	TUNING.TENTACLE_PILLAR_ARM_DAMAGE = 5;
	TUNING.TENTACLE_PILLAR_ARM_ATTACK_PERIOD = 3;
	TUNING.TENTACLE_PILLAR_ARM_ATTACK_DIST = 3;
	TUNING.TENTACLE_PILLAR_ARM_STOPATTACK_DIST = 5;
	TUNING.TENTACLE_PILLAR_ARM_HEALTH = 20;
	TUNING.TENTACLE_PILLAR_ARM_EMERGE_TIME = 200;

	TUNING.EYEPLANT_DAMAGE = 20;
	TUNING.EYEPLANT_HEALTH = 30;
	TUNING.EYEPLANT_ATTACK_PERIOD = 1;
	TUNING.EYEPLANT_ATTACK_DIST = 2.5;
	TUNING.EYEPLANT_STOPATTACK_DIST = 4;

	TUNING.LUREPLANT_HIBERNATE_TIME = total_day_time * 2;
	TUNING.LUREPLANT_GROWTHCHANCE = 0.02;

	TUNING.TALLBIRD_HEALTH = 400;
	TUNING.TALLBIRD_DAMAGE = 50;
	TUNING.TALLBIRD_ATTACK_PERIOD = 2;
	TUNING.TALLBIRD_HATEPIGS_DIST = 16;
	TUNING.TALLBIRD_TARGET_DIST = 8;
	TUNING.TALLBIRD_DEFEND_DIST = 12;
	TUNING.TALLBIRD_ATTACK_RANGE = 3;

	TUNING.TEENBIRD_HEALTH = 400*.75;
	TUNING.TEENBIRD_DAMAGE = 50*.75;
	TUNING.TEENBIRD_ATTACK_PERIOD = 2;
	TUNING.TEENBIRD_ATTACK_RANGE = 3;
	TUNING.TEENBIRD_DAMAGE_PECK = 2;
	TUNING.TEENBIRD_PECK_PERIOD = 4;
	TUNING.TEENBIRD_HUNGER = 60;
	TUNING.TEENBIRD_STARVE_TIME = total_day_time * 1;
	TUNING.TEENBIRD_STARVE_KILL_TIME = 240;
	TUNING.TEENBIRD_GROW_TIME = total_day_time*18;
	TUNING.TEENBIRD_TARGET_DIST = 8;

	TUNING.SMALLBIRD_HEALTH = 50;
	TUNING.SMALLBIRD_DAMAGE = 10;
	TUNING.SMALLBIRD_ATTACK_PERIOD = 1;
	TUNING.SMALLBIRD_ATTACK_RANGE = 3;
	TUNING.SMALLBIRD_HUNGER = 20;
	TUNING.SMALLBIRD_STARVE_TIME = total_day_time * 1;
	TUNING.SMALLBIRD_STARVE_KILL_TIME = 120;
	TUNING.SMALLBIRD_GROW_TIME = total_day_time*10;

	TUNING.SMALLBIRD_HATCH_CRACK_TIME = 10; -- set by fire for this much time to start hatching progress
	TUNING.SMALLBIRD_HATCH_TIME = total_day_time * 3; -- must be content for this amount of cumulative time to hatch
	TUNING.SMALLBIRD_HATCH_FAIL_TIME = night_time * .5; -- being too hot or too cold this long will kill the egg

	TUNING.HATCH_UPDATE_PERIOD = 3;
	TUNING.HATCH_CAMPFIRE_RADIUS = 4;

	TUNING.CHESTER_HEALTH = wilson_health*3;
	TUNING.CHESTER_RESPAWN_TIME = total_day_time * 1;
	TUNING.CHESTER_HEALTH_REGEN_AMOUNT = (wilson_health*3) * 3/60;
	TUNING.CHESTER_HEALTH_REGEN_PERIOD = 3;

	TUNING.PROTOTYPER_TREES = {
		SCIENCEMACHINE =
		{
			SCIENCE = 1;
			MAGIC = 1,
			ANCIENT = 0;
		};

		ALCHEMYMACHINE =
		{
			SCIENCE = 2;
			MAGIC = 1;
			ANCIENT = 0;
		};

		PRESTIHATITATOR =
		{
			SCIENCE = 0;
			MAGIC = 2;
			ANCIENT = 0,
		};

		SHADOWMANIPULATOR =
		{
			SCIENCE = 0;
			MAGIC = 3;
			ANCIENT = 0,
		};

		ANCIENTALTAR_LOW =
		{
			SCIENCE = 0;
			MAGIC = 0;
			ANCIENT = 2;
		};

		ANCIENTALTAR_HIGH =
		{
			SCIENCE = 0;
			MAGIC = 0;
			ANCIENT = 4;
		};
	};


	TUNING.RABBIT_HEALTH = 25;

	TUNING.FROG_HEALTH = 100;
	TUNING.FROG_DAMAGE = 10;
	TUNING.FROG_ATTACK_PERIOD = 1;
	TUNING.FROG_TARGET_DIST = 4;

	TUNING.HOUND_SPECIAL_CHANCE =
	{
		{minday=0, chance=0};
		{minday=15, chance=.1};
		{minday=30, chance=.2};
		{minday=50, chance=.333};
		{minday=75, chance=.5};
	};

	TUNING.HOUND_HEALTH = 150;
	TUNING.HOUND_DAMAGE = 20;
	TUNING.HOUND_ATTACK_PERIOD = 2;
	TUNING.HOUND_TARGET_DIST = 20;
	TUNING.HOUND_SPEED = 10;

	TUNING.HOUND_FOLLOWER_TARGET_DIST = 10;
	TUNING.HOUND_FOLLOWER_TARGET_KEEP = 20;

	TUNING.FIREHOUND_HEALTH = 100;
	TUNING.FIREHOUND_DAMAGE = 30;
	TUNING.FIREHOUND_ATTACK_PERIOD = 2;
	TUNING.FIREHOUND_SPEED = 10;

	TUNING.ICEHOUND_HEALTH = 100;
	TUNING.ICEHOUND_DAMAGE = 30;
	TUNING.ICEHOUND_ATTACK_PERIOD = 2;
	TUNING.ICEHOUND_SPEED = 10;

	TUNING.MOSQUITO_WALKSPEED = 8;
	TUNING.MOSQUITO_RUNSPEED = 12;
	TUNING.MOSQUITO_DAMAGE = 3;
	TUNING.MOSQUITO_HEALTH = 100;
	TUNING.MOSQUITO_ATTACK_PERIOD = 7;
	TUNING.MOSQUITO_MAX_DRINKS = 4;
	TUNING.MOSQUITO_BURST_DAMAGE = 34;
	TUNING.MOSQUITO_BURST_RANGE = 4;

	TUNING.KRAMPUS_HEALTH = 200;
	TUNING.KRAMPUS_DAMAGE = 50;
	TUNING.KRAMPUS_ATTACK_PERIOD = 1.2;
	TUNING.KRAMPUS_SPEED = 7;
	TUNING.KRAMPUS_THRESHOLD = 30;
	TUNING.KRAMPUS_THRESHOLD_VARIANCE = 20;
	TUNING.KRAMPUS_INCREASE_LVL1 = 50;
	TUNING.KRAMPUS_INCREASE_LVL2 = 100;
	TUNING.KRAMPUS_INCREASE_RAMP = 2;
	TUNING.KRAMPUS_NAUGHTINESS_DECAY_PERIOD = 60;

	TUNING.TERRORBEAK_SPEED = 7;
	TUNING.TERRORBEAK_HEALTH = 400;
	TUNING.TERRORBEAK_DAMAGE = 50;
	TUNING.TERRORBEAK_ATTACK_PERIOD= 1.5;

	TUNING.CRAWLINGHORROR_SPEED = 3;
	TUNING.CRAWLINGHORROR_HEALTH = 300;
	TUNING.CRAWLINGHORROR_DAMAGE = 20;
	TUNING.CRAWLINGHORROR_ATTACK_PERIOD= 2.5;

	TUNING.SHADOWCREATURE_TARGET_DIST = 20;

	TUNING.FROSTY_BREATH = -5;

	TUNING.SEEDS_GROW_TIME = day_time*6;
	TUNING.FARM1_GROW_BONUS = 1;
	TUNING.FARM2_GROW_BONUS = .6667;
	TUNING.FARM3_GROW_BONUS = .333;
	TUNING.POOP_FERTILIZE = day_time;
	TUNING.POOP_SOILCYCLES = 10;
	TUNING.POOP_WITHEREDCYCLES = 1;
	TUNING.GUANO_FERTILIZE = day_time * 1.5;
	TUNING.GUANO_SOILCYCLES = 12;
	TUNING.GUANO_WITHEREDCYCLES = 1;

	TUNING.SPOILEDFOOD_FERTILIZE = day_time/4;
	TUNING.SPOILEDFOOD_SOILCYCLES = 2;
	TUNING.SPOILEDFOOD_WITHEREDCYCLES = 0.5;



	TUNING.FISHING_CATCH_CHANCE = 0.4;
	TUNING.FISHING_LOSEROD_CHANCE = 0.4;

	TUNING.TINY_FUEL = seg_time*.25;
	TUNING.SMALL_FUEL = seg_time * .5;
	TUNING.MED_FUEL = seg_time * 1.5;
	TUNING.MED_LARGE_FUEL = seg_time * 3;
	TUNING.LARGE_FUEL = seg_time * 6;

	TUNING.TINY_BURNTIME = seg_time*.1;
	TUNING.SMALL_BURNTIME = seg_time*.25;
	TUNING.MED_BURNTIME = seg_time*0.5;
	TUNING.LARGE_BURNTIME = seg_time;

	TUNING.CAMPFIRE_RAIN_RATE = 2.5;
	TUNING.CAMPFIRE_FUEL_MAX = (night_time+dusk_time)*1.5;
	TUNING.CAMPFIRE_FUEL_START = (night_time+dusk_time)*.75;

	TUNING.ROCKLIGHT_FUEL_MAX = (night_time+dusk_time)*1.5;

	TUNING.FIREPIT_RAIN_RATE = 2;
	TUNING.FIREPIT_FUEL_MAX = (night_time+dusk_time)*2;
	TUNING.FIREPIT_FUEL_START = night_time+dusk_time;
	TUNING.FIREPIT_BONUS_MULT = 2;

	TUNING.PIGTORCH_RAIN_RATE = 2;
	TUNING.PIGTORCH_FUEL_MAX = night_time;

	TUNING.NIGHTLIGHT_FUEL_MAX = (night_time+dusk_time)*3;
	TUNING.NIGHTLIGHT_FUEL_START = (night_time+dusk_time);

	TUNING.TORCH_RAIN_RATE = 1.5;
	TUNING.TORCH_FUEL = night_time*1.25;

	TUNING.MINERHAT_LIGHTTIME = (night_time+dusk_time)*2.6;
	TUNING.LANTERN_LIGHTTIME = (night_time+dusk_time)*2.6;
	TUNING.SPIDERHAT_PERISHTIME = 4*seg_time;
	TUNING.SPIDERHAT_RANGE = 12;
	TUNING.ONEMANBAND_PERISHTIME = 6*seg_time;
	TUNING.ONEMANBAND_RANGE = 12;

	TUNING.UMBRELLA_PERISHTIME = total_day_time*6;

	TUNING.EARMUFF_PERISHTIME = total_day_time*5;
	TUNING.WINTERHAT_PERISHTIME = total_day_time*10;
	TUNING.BEEFALOHAT_PERISHTIME = total_day_time*10;

	TUNING.TRUNKVEST_PERISHTIME = total_day_time*15;
	TUNING.SWEATERVEST_PERISHTIME = total_day_time*10;
	TUNING.HUNGERBELT_PERISHTIME = total_day_time*8;

	TUNING.WALRUSHAT_PERISHTIME = total_day_time*25;
	TUNING.FEATHERHAT_PERISHTIME = total_day_time*8;
	TUNING.TOPHAT_PERISHTIME = total_day_time*8;

	TUNING.GRASS_REGROW_TIME = total_day_time*3;
	TUNING.SAPLING_REGROW_TIME = total_day_time*4;
	TUNING.MARSHBUSH_REGROW_TIME = total_day_time*4;
	TUNING.FLOWER_CAVE_REGROW_TIME = total_day_time*3;
	TUNING.LICHEN_REGROW_TIME = total_day_time*5;

	TUNING.BERRY_REGROW_TIME = total_day_time*3;
	TUNING.BERRY_REGROW_INCREASE = total_day_time*.5;
	TUNING.BERRY_REGROW_VARIANCE = total_day_time*2;
	TUNING.BERRYBUSH_CYCLES = 3;

	TUNING.REEDS_REGROW_TIME = total_day_time*3;

	TUNING.CROW_LEAVINGS_CHANCE = .3333;
	TUNING.BIRD_TRAP_CHANCE = 0.025;
	TUNING.BIRD_HEALTH = 25;

	TUNING.RABBIT_RESPAWN_TIME = day_time*4;

	TUNING.FULL_ABSORPTION = 1;
	TUNING.ARMORGRASS = wilson_health*1.5;
	TUNING.ARMORGRASS_ABSORPTION = .6;
	TUNING.ARMORWOOD = wilson_health*3;
	TUNING.ARMORWOOD_ABSORPTION = .8;
	TUNING.ARMORMARBLE = wilson_health*7;
	TUNING.ARMORMARBLE_ABSORPTION = .95;
	TUNING.ARMORSNURTLESHELL_ABSORPTION = 0.6;
	TUNING.ARMORSNURTLESHELL = wilson_health*7;
	TUNING.ARMORMARBLE_SLOW = 0.7;
	TUNING.ARMORRUINS_ABSORPTION = 0.9;
	TUNING.ARMORRUINS = wilson_health * 12;
	TUNING.ARMORSLURPER_ABSORPTION = 0.6;
	TUNING.ARMORSLURPER_SLOW_HUNGER = 0.6;
	TUNING.ARMORSLURPER = wilson_health * 4;
	TUNING.ARMOR_FOOTBALLHAT = wilson_health*3;
	TUNING.ARMOR_FOOTBALLHAT_ABSORPTION = .8;

	TUNING.ARMOR_RUINSHAT = wilson_health*8;
	TUNING.ARMOR_RUINSHAT_ABSORPTION = 0.9;
	TUNING.ARMOR_RUINSHAT_PROC_CHANCE = 0.33;
	TUNING.ARMOR_RUINSHAT_COOLDOWN = 5;
	TUNING.ARMOR_RUINSHAT_DURATION = 4;
	TUNING.ARMOR_RUINSHAT_DMG_AS_SANITY = 0.05;

	TUNING.ARMOR_SLURTLEHAT = wilson_health*5;
	TUNING.ARMOR_SLURTLEHAT_ABSORPTION = 0.9;
	TUNING.ARMOR_BEEHAT = wilson_health*5;
	TUNING.ARMOR_BEEHAT_ABSORPTION = .8;
	TUNING.ARMOR_SANITY = wilson_health * 5;
	TUNING.ARMOR_SANITY_ABSORPTION = .95;
	TUNING.ARMOR_SANITY_DMG_AS_SANITY = 0.10;


	TUNING.PANFLUTE_SLEEPTIME = 20;
	TUNING.PANFLUTE_SLEEPRANGE = 15;
	TUNING.PANFLUTE_USES = 10;
	TUNING.HORN_RANGE = 25;
	TUNING.HORN_USES = 10;
	TUNING.HORN_EFFECTIVE_TIME = 20;
	TUNING.HORN_MAX_FOLLOWERS = 5;
	TUNING.MANDRAKE_SLEEP_TIME = 10;
	TUNING.MANDRAKE_SLEEP_RANGE = 15;
	TUNING.MANDRAKE_SLEEP_RANGE_COOKED = 25;

	TUNING.GOLD_VALUES=
	{
		MEAT = 1;
		RAREMEAT = 5;
		TRINKETS=
		{
			4,6,4,5,4,5,4,8,7,2,5,8;
		};
		SUNKEN_BOAT_TRINKETS =
		{ 2, 2, 7, 1, 4 };
	};

	TUNING.RESEARCH_COST_CHEAP = 30;
	TUNING.RESEARCH_COST_MEDIUM = 100;
	TUNING.RESEARCH_COST_EXPENSIVE = 200;

	TUNING.SPIDERQUEEN_WALKSPEED = 1.75;
	TUNING.SPIDERQUEEN_HEALTH = 1250;
	TUNING.SPIDERQUEEN_DAMAGE = 80;
	TUNING.SPIDERQUEEN_ATTACKPERIOD = 3;
	TUNING.SPIDERQUEEN_ATTACKRANGE = 5;
	TUNING.SPIDERQUEEN_FOLLOWERS = 16;
	TUNING.SPIDERQUEEN_GIVEBIRTHPERIOD = 20;
	TUNING.SPIDERQUEEN_MINWANDERTIME = total_day_time * 1.5;
	TUNING.SPIDERQUEEN_MINDENSPACING = 20;

	TUNING.TRAP_TEETH_USES = 10;
	TUNING.TRAP_TEETH_DAMAGE = 60;
	TUNING.TRAP_TEETH_RADIUS = 1.5;


	TUNING.HEALING_TINY = 1;
	TUNING.HEALING_SMALL = 3;
	TUNING.HEALING_MEDSMALL = 8;
	TUNING.HEALING_MED = 20;
	TUNING.HEALING_MEDLARGE = 30;
	TUNING.HEALING_LARGE = 40;
	TUNING.HEALING_HUGE = 60;
	TUNING.HEALING_SUPERHUGE = 100;

	TUNING.SANITY_SUPERTINY = 1;
	TUNING.SANITY_TINY = 5;
	TUNING.SANITY_SMALL = 10;
	TUNING.SANITY_MED = 15;
	TUNING.SANITY_MEDLARGE = 20;
	TUNING.SANITY_LARGE = 33;
	TUNING.SANITY_HUGE = 50;

	TUNING.PERISH_ONE_DAY = 1*total_day_time*perish_warp;
	TUNING.PERISH_TWO_DAY = 2*total_day_time*perish_warp;
	TUNING.PERISH_SUPERFAST = 3*total_day_time*perish_warp;
	TUNING.PERISH_FAST = 6*total_day_time*perish_warp;
	TUNING.PERISH_MED = 10*total_day_time*perish_warp;
	TUNING.PERISH_SLOW = 15*total_day_time*perish_warp;
	TUNING.PERISH_PRESERVED = 20*total_day_time*perish_warp;
	TUNING.PERISH_SUPERSLOW = 40*total_day_time*perish_warp;

	TUNING.DRY_FAST = total_day_time;
	TUNING.DRY_MED = 2*total_day_time;

	TUNING.CALORIES_TINY = calories_per_day/8; -- berries
	TUNING.CALORIES_SMALL = calories_per_day/6; -- veggies
	TUNING.CALORIES_MEDSMALL = calories_per_day/4;
	TUNING.CALORIES_MED = calories_per_day/3; -- meat
	TUNING.CALORIES_LARGE = calories_per_day/2; -- cooked meat
	TUNING.CALORIES_HUGE = calories_per_day; -- crockpot foods?
	TUNING.CALORIES_SUPERHUGE = calories_per_day*2; -- crockpot foods?

	TUNING.SPOILED_HEALTH = -1;
	TUNING.SPOILED_HUNGER = -10;
	TUNING.PERISH_FRIDGE_MULT = .5;
	TUNING.PERISH_GROUND_MULT = 1.5;
	TUNING.PERISH_GLOBAL_MULT = 1;
	TUNING.PERISH_WINTER_MULT = .75;
	TUNING.PERISH_SUMMER_MULT = 1.25;

	TUNING.STALE_FOOD_HUNGER = .667;
	TUNING.SPOILED_FOOD_HUNGER = .5;

	TUNING.STALE_FOOD_HEALTH = .333;
	TUNING.SPOILED_FOOD_HEALTH = 0;

	TUNING.BASE_COOK_TIME = night_time*.3333;

	TUNING.TALLBIRDEGG_HEALTH = 15;
	TUNING.TALLBIRDEGG_HUNGER = 15;
	TUNING.TALLBIRDEGG_COOKED_HEALTH = 25;
	TUNING.TALLBIRDEGG_COOKED_HUNGER = 30;

	TUNING.REPAIR_CUTSTONE_HEALTH = 50;
	TUNING.REPAIR_ROCKS_HEALTH = 50/3;
	TUNING.REPAIR_GEMS_WORK = 1;
	TUNING.REPAIR_GEARS_WORK = 1;

	TUNING.REPAIR_THULECITE_WORK = 1.5;
	TUNING.REPAIR_THULECITE_HEALTH = 100;

	TUNING.REPAIR_THULECITE_PIECES_WORK = 1.5/6;
	TUNING.REPAIR_THULECITE_PIECES_HEALTH = 100/6;

	TUNING.REPAIR_BOARDS_HEALTH = 25;
	TUNING.REPAIR_LOGS_HEALTH = 25/4;
	TUNING.REPAIR_STICK_HEALTH = 13;
	TUNING.REPAIR_CUTGRASS_HEALTH = 13;

	TUNING.HAYWALL_HEALTH = 100;
	TUNING.WOODWALL_HEALTH = 200;
	TUNING.STONEWALL_HEALTH = 400;
	TUNING.RUINSWALL_HEALTH = 800;

	TUNING.EFFIGY_HEALTH_PENALTY = 30;

	TUNING.SANITY_HIGH_LIGHT = .6;
	TUNING.SANITY_LOW_LIGHT =  0.1;

	TUNING.SANITY_DAPPERNESS = 1;

	TUNING.SANITY_BECOME_SANE_THRESH = 35/200;
	TUNING.SANITY_BECOME_INSANE_THRESH = 30/200;

	TUNING.SANITY_DAY_GAIN = 0;--100/(day_time*32);

	TUNING.SANITY_NIGHT_LIGHT = -100/(night_time*20);
	TUNING.SANITY_NIGHT_MID = -100/(night_time*20);
	TUNING.SANITY_NIGHT_DARK = -100/(night_time*2);

	TUNING.SANITYAURA_TINY = 100/(seg_time*32);
	TUNING.SANITYAURA_SMALL = 100/(seg_time*8);
	TUNING.SANITYAURA_MED = 100/(seg_time*5);
	TUNING.SANITYAURA_LARGE = 100/(seg_time*2);
	TUNING.SANITYAURA_HUGE = 100/(seg_time*.5);

	TUNING.DAPPERNESS_TINY = 100/(day_time*15);
	TUNING.DAPPERNESS_SMALL = 100/(day_time*10);
	TUNING.DAPPERNESS_MED = 100/(day_time*6);
	TUNING.DAPPERNESS_LARGE = 100/(day_time*3);
	TUNING.DAPPERNESS_HUGE = 100/(day_time);


	TUNING.MOISTURE_SANITY_PENALTY_MAX = 100/(day_time*15);


	TUNING.CRAZINESS_SMALL = -100/(day_time*2);
	TUNING.CRAZINESS_MED = -100/(day_time);

	TUNING.RABBIT_RUN_SPEED = 5;
	TUNING.SANITY_EFFECT_RANGE	= 10;
	TUNING.WINTER_LENGTH = 15;
	TUNING.SUMMER_LENGTH = 20;

	TUNING.CREEPY_EYES =
	{
		{maxsanity=.8, maxeyes=0};
		{maxsanity=.6, maxeyes=2};
		{maxsanity=.4, maxeyes=4};
		{maxsanity=.2, maxeyes=6};
	};

	TUNING.DIVINING_DISTANCES =
	{
		{maxdist=50, describe="hot", pingtime=1};
		{maxdist=100, describe="warmer", pingtime=2};
		{maxdist=200, describe="warm", pingtime=4};
		{maxdist=400, describe="cold", pingtime=8};
	};
	TUNING.DIVINING_MAXDIST = 300;
	TUNING.DIVINING_DEFAULTPING = 8;

	--expressed in 'additional time before you freeze to death'
	TUNING.INSULATION_TINY = seg_time;
	TUNING.INSULATION_SMALL = seg_time*2;
	TUNING.INSULATION_MED = seg_time*4;
	TUNING.INSULATION_LARGE = seg_time*8;
	TUNING.INSULATION_PER_BEARD_BIT = seg_time*.5;

	TUNING.CROP_BONUS_TEMP = 28;
	TUNING.MIN_CROP_GROW_TEMP = 5;
	TUNING.CROP_HEAT_BONUS = 1;
	TUNING.CROP_RAIN_BONUS = 3;

	TUNING.WARM_DEGREES_PER_SEC = 1;
	TUNING.THAW_DEGREES_PER_SEC = 5;

	TUNING.TENT_USES = 6;

	TUNING.BEARDLING_SANITY = .4;
	TUNING.UMBRELLA_USES = 20;

	TUNING.GUNPOWDER_RANGE = 3;
	TUNING.GUNPOWDER_DAMAGE = 200;
	TUNING.BIRD_RAIN_FACTOR = .25;

	TUNING.RESURRECT_HEALTH = 50;

	TUNING.SEWINGKIT_USES = 5;
	TUNING.SEWINGKIT_REPAIR_VALUE = total_day_time*5;


	TUNING.RABBIT_CARROT_LOYALTY = seg_time*8;
	TUNING.BUNNYMAN_DAMAGE = 40;
	TUNING.BEARDLORD_DAMAGE = 60;
	TUNING.BUNNYMAN_HEALTH = 200;
	TUNING.BUNNYMAN_ATTACK_PERIOD = 2;
	TUNING.BEARDLORD_ATTACK_PERIOD = 1;
	TUNING.BUNNYMAN_RUN_SPEED = 6;
	TUNING.BUNNYMAN_WALK_SPEED = 3;
	TUNING.BUNNYMAN_PANIC_THRESH = .333;
	TUNING.BEARDLORD_PANIC_THRESH = .25;
	TUNING.BUNNYMAN_HEALTH_REGEN_PERIOD = 5;
	TUNING.BUNNYMAN_HEALTH_REGEN_AMOUNT = (200/120)*5;
	TUNING.BUNNYMAN_SEE_MEAT_DIST = 8;

	TUNING.CAVE_BANANA_GROW_TIME = 4*total_day_time;
	TUNING.ROCKY_SPAWN_DELAY = 4*total_day_time;
	TUNING.ROCKY_SPAWN_VAR = 0;

	TUNING.ROCKY_DAMAGE = 75;
	TUNING.ROCKY_HEALTH = 1500;
	TUNING.ROCKY_WALK_SPEED = 2;
	TUNING.ROCKY_MAX_SCALE = 1.2;
	TUNING.ROCKY_MIN_SCALE = .75;
	TUNING.ROCKY_GROW_RATE = (1.2-.75) / (total_day_time*40);
	TUNING.ROCKY_LOYALTY = seg_time*6;
	TUNING.ROCKY_ABSORB = 0.95;
	TUNING.ROCKY_REGEN_AMOUNT = 10;
	TUNING.ROCKY_REGEN_PERIOD = 1;
	TUNING.ROCKYHERD_RANGE = 40;
	TUNING.ROCKYHERD_MAX_IN_RANGE = 12;

	TUNING.MONKEY_MELEE_DAMAGE = 20;
	TUNING.MONKEY_HEALTH = 125;
	TUNING.MONKEY_ATTACK_PERIOD = 2;
	TUNING.MONKEY_MELEE_RANGE = 3;
	TUNING.MONKEY_RANGED_RANGE = 17;
	TUNING.MONKEY_MOVE_SPEED = 7;
	TUNING.MONKEY_NIGHTMARE_CHASE_DIST = 40;

	TUNING.LIGHTER_ATTACK_IGNITE_PERCENT = .5;
	TUNING.LIGHTER_DAMAGE = wilson_attack*.5;
	TUNING.WILLOW_LIGHTFIRE_SANITY_THRESH = .5;
	TUNING.WX78_RAIN_HURT_RATE = 1;


	TUNING.WOLFGANG_HUNGER = 300;
	TUNING.WOLFGANG_START_HUNGER = 200;
	TUNING.WOLFGANG_START_MIGHTY_THRESH = 225;
	TUNING.WOLFGANG_END_MIGHTY_THRESH = 220;
	TUNING.WOLFGANG_START_WIMPY_THRESH = 100;
	TUNING.WOLFGANG_END_WIMPY_THRESH = 105;

	TUNING.WOLFGANG_HUNGER_RATE_MULT_MIGHTY = 3;
	TUNING.WOLFGANG_HUNGER_RATE_MULT_NORMAL = 1.5;
	TUNING.WOLFGANG_HUNGER_RATE_MULT_WIMPY = 1;

	TUNING.WOLFGANG_HEALTH_MIGHTY = 300;
	TUNING.WOLFGANG_HEALTH_NORMAL = 200;
	TUNING.WOLFGANG_HEALTH_WIMPY = 150;

	TUNING.WOLFGANG_ATTACKMULT_MIGHTY_MAX = 2;
	TUNING.WOLFGANG_ATTACKMULT_MIGHTY_MIN = 1.25;
	TUNING.WOLFGANG_ATTACKMULT_NORMAL = 1;
	TUNING.WOLFGANG_ATTACKMULT_WIMPY_MAX = .75;
	TUNING.WOLFGANG_ATTACKMULT_WIMPY_MIN = .5;

	TUNING.WENDY_DAMAGE_MULT = .75;
	TUNING.WENDY_SANITY_MULT = .75;

	TUNING.WICKERBOTTOM_SANITY = 250;
	TUNING.WICKERBOTTOM_STALE_FOOD_HUNGER = .333;
	TUNING.WICKERBOTTOM_SPOILED_FOOD_HUNGER = .167;

	TUNING.WICKERBOTTOM_STALE_FOOD_HEALTH = .25;
	TUNING.WICKERBOTTOM_SPOILED_FOOD_HEALTH = 0;

	TUNING.FISSURE_CALMTIME_MIN = 600;
	TUNING.FISSURE_CALMTIME_MAX = 1200;
	TUNING.FISSURE_WARNTIME_MIN = 20;
	TUNING.FISSURE_WARNTIME_MAX = 30;
	TUNING.FISSURE_NIGHTMARETIME_MIN = 160;
	TUNING.FISSURE_NIGHTMARETIME_MAX = 260;
	TUNING.FISSURE_DAWNTIME_MIN = 30;
	TUNING.FISSURE_DAWNTIME_MAX = 45;


	TUNING.EYETURRET_DAMAGE = 65;
	TUNING.EYETURRET_HEALTH = 1000;
	TUNING.EYETURRET_REGEN = 12;
	TUNING.EYETURRET_RANGE = 15;
	TUNING.EYETURRET_ATTACK_PERIOD = 3;


	TUNING.TRANSITIONTIME =
	{
		CALM = 2;
		WARN = 2;
		NIGHTMARE = 2;
		DAWN = 2;
	};

	TUNING.SHADOWWAXWELL_LIFETIME = total_day_time * 2.5;
	TUNING.SHADOWWAXWELL_SPEED = 6;
	TUNING.SHADOWWAXWELL_DAMAGE = 40;
	TUNING.SHADOWWAXWELL_LIFE = 75;
	TUNING.SHADOWWAXWELL_ATTACK_PERIOD = 2;
	TUNING.SHADOWWAXWELL_SANITY_PENALTY = 55;
	TUNING.SHADOWWAXWELL_HEALTH_COST = 15;
	TUNING.SHADOWWAXWELL_FUEL_COST = 2;

	TUNING.LIVINGTREE_CHANCE = 0.55;

	TUNING.FLOTSAM_REBATCH_TIME = total_day_time * 15;
	TUNING.FLOTSAM_INDIVIDUAL_TIME = total_day_time * 0.2;
	TUNING.FLOTSAM_BATCH_SIZE = { min = 2, max = 5 };
	TUNING.FLOTSAM_SPAWN_RADIUS = 35;
	TUNING.FLOTSAM_DRIFT_SPEED = 1;
	TUNING.FLOTSAM_DECAY_TIME = total_day_time * 2;
	
end

return ReTune
