/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.CovertOpsManager;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AgentActionBase
extends BaseCommandPlugin {
    protected static final String STRING_CATEGORY = "exerelin_agents";
    protected static final Map<CovertOpsManager.CovertActionResult, String> RESULT_STRINGS = new HashMap<CovertOpsManager.CovertActionResult, String>();
    protected String agentType = "agent";
    protected CovertOpsManager.CovertActionResult result = null;

    protected boolean useSpecialPerson(String typeId, int count) {
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        List stacks = cargo.getStacksCopy();
        boolean agentSpent = false;
        for (CargoStackAPI stack : stacks) {
            if (stack.isNull() || stack.getCommodityId() == null || !stack.getCommodityId().equals(typeId)) continue;
            if (stack.getSize() < (float)count) {
                return false;
            }
            stack.subtract((float)count);
            agentSpent = true;
            if (!(stack.getSize() < 1.0f)) break;
            cargo.removeEmptyStacks();
            break;
        }
        if (agentSpent) {
            this.agentType = typeId;
        }
        return agentSpent;
    }

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        MemoryAPI memory = memoryMap.get("market");
        memory.set("$alertLevel", (Object)Float.valueOf(CovertOpsManager.getAlertLevel(dialog.getInteractionTarget().getMarket())), 0.0f);
        if (this.result != null) {
            String str = StringHelper.getString(STRING_CATEGORY, RESULT_STRINGS.get((Object)this.result));
            str = StringHelper.substituteToken(str, "$agentType", StringHelper.getString(STRING_CATEGORY, this.agentType));
            String verb = StringHelper.getString(STRING_CATEGORY, "verbSuccess");
            Color color = Misc.getHighlightColor();
            if (!this.result.isSucessful()) {
                verb = StringHelper.getString(STRING_CATEGORY, "verbFailed");
                color = Misc.getNegativeHighlightColor();
            }
            str = StringHelper.substituteToken(str, "$resultVerb", verb);
            TextPanelAPI text = dialog.getTextPanel();
            text.addParagraph(str);
            text.highlightInLastPara(color, new String[]{verb});
        }
        return true;
    }

    static {
        RESULT_STRINGS.put(CovertOpsManager.CovertActionResult.SUCCESS, "resultSuccess");
        RESULT_STRINGS.put(CovertOpsManager.CovertActionResult.SUCCESS_DETECTED, "resultSuccessDetected");
        RESULT_STRINGS.put(CovertOpsManager.CovertActionResult.FAILURE, "resultFailure");
        RESULT_STRINGS.put(CovertOpsManager.CovertActionResult.FAILURE_DETECTED, "resultFailureDetected");
    }
}

