/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AgentActionBase;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.CovertOpsManager;
import exerelin.campaign.StatsTracker;
import exerelin.campaign.fleets.ResponseFleetManager;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.List;
import java.util.Map;

public class AgentGatherIntel
extends AgentActionBase {
    protected Color getColorFromScale(float number, float max, boolean reverse) {
        float proportion = number / max;
        if (proportion > 1.0f) {
            proportion = 1.0f;
        } else if (proportion < 0.0f) {
            proportion = 0.0f;
        }
        int r = (int)(255.0f * (1.0f - proportion));
        int g = (int)(255.0f * proportion);
        int b = 96;
        if (reverse) {
            r = 255 - r;
            g = 255 - g;
        }
        return new Color(r, g, b);
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        boolean superResult = this.useSpecialPerson("agent", 1);
        if (!superResult) {
            return false;
        }
        SectorEntityToken target = dialog.getInteractionTarget();
        MarketAPI market = target.getMarket();
        TextPanelAPI text = dialog.getTextPanel();
        text.addParagraph(market.getName() + " intel report");
        text.setFontSmallInsignia();
        text.addParagraph("-----------------------------------------------------------------------------");
        float stability = market.getStabilityValue();
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString("stability")) + ": " + stability);
        text.highlightInLastPara(this.getColorFromScale(stability, 10.0f, false), new String[]{"" + stability});
        int alertLevel = Math.round(CovertOpsManager.getAlertLevel(market) * 100.0f);
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString("exerelin_agents", "alertLevel")) + ": " + alertLevel + "%");
        text.highlightInLastPara(this.getColorFromScale(alertLevel, 100.0f, true), new String[]{"" + alertLevel});
        float reserveSize = ResponseFleetManager.getReserveSize(market);
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString("exerelin_agents", "reserveSize")) + ": " + reserveSize);
        text.highlightInLastPara(Misc.getHighlightColor(), new String[]{"" + reserveSize});
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
        StatsTracker.getStatsTracker().notifyAgentsUsed(1);
        return super.execute(ruleId, dialog, params, memoryMap);
    }
}

