/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AgentActionBase;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.CovertOpsManager;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.campaign.StatsTracker;
import exerelin.campaign.alliances.Alliance;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtilsFaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AgentLowerRelations
extends AgentActionBase {
    protected static final Map<RepLevel, Float> TARGET_WEIGHTINGS = new HashMap<RepLevel, Float>();

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        boolean superResult = this.useSpecialPerson("agent", 1);
        if (!superResult) {
            return false;
        }
        SectorAPI sector = Global.getSector();
        SectorEntityToken target = dialog.getInteractionTarget();
        MarketAPI market = target.getMarket();
        String targetFactionId = target.getFaction().getId();
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        FactionAPI playerAlignedFaction = sector.getFaction(playerAlignedFactionId);
        WeightedRandomPicker targetPicker = new WeightedRandomPicker();
        Alliance targetAlliance = AllianceManager.getFactionAlliance(targetFactionId);
        ArrayList<String> factions = SectorManager.getLiveFactionIdsCopy();
        for (String factionId : factions) {
            ExerelinFactionConfig factionConf;
            if (factionId.equals(targetFactionId) || factionId.equals(playerAlignedFactionId) || CovertOpsManager.DISALLOWED_FACTIONS.contains(factionId) || (factionConf = ExerelinConfig.getExerelinFactionConfig(factionId)) != null && !factionConf.allowAgentActions) continue;
            float weight = 0.001f;
            RepLevel rep = playerAlignedFaction.getRelationshipLevel(factionId);
            if (TARGET_WEIGHTINGS.containsKey(rep)) {
                weight = TARGET_WEIGHTINGS.get(rep).floatValue();
            }
            if (ExerelinUtilsFaction.isPirateFaction(factionId)) {
                weight *= 0.25f;
            }
            if (AllianceManager.getFactionAlliance(factionId) == targetAlliance) {
                weight *= 4.0f;
            }
            float dominance = DiplomacyManager.getDominanceFactor(factionId);
            targetPicker.add((Object)factionId, weight *= 1.0f + dominance * 2.0f);
        }
        String targetId = (String)targetPicker.pick();
        if (targetId == null) {
            return false;
        }
        this.result = CovertOpsManager.agentLowerRelations(market, playerAlignedFaction, target.getFaction(), sector.getFaction(targetId), true);
        StatsTracker.getStatsTracker().notifyAgentsUsed(1);
        return super.execute(ruleId, dialog, params, memoryMap);
    }

    static {
        TARGET_WEIGHTINGS.put(RepLevel.NEUTRAL, Float.valueOf(0.5f));
        TARGET_WEIGHTINGS.put(RepLevel.SUSPICIOUS, Float.valueOf(1.0f));
        TARGET_WEIGHTINGS.put(RepLevel.INHOSPITABLE, Float.valueOf(1.5f));
        TARGET_WEIGHTINGS.put(RepLevel.HOSTILE, Float.valueOf(2.0f));
        TARGET_WEIGHTINGS.put(RepLevel.VENGEFUL, Float.valueOf(2.5f));
    }
}

