/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.InvasionRound;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.List;
import java.util.Map;

public class ExecuteInvasionRound
extends BaseCommandPlugin {
    protected static final String STRING_CATEGORY = "exerelin_invasion";

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        SectorEntityToken target = dialog.getInteractionTarget();
        TextPanelAPI text = dialog.getTextPanel();
        MemoryAPI memory = memoryMap.get("local");
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        FactionAPI faction = target.getFaction();
        InvasionRound.InvasionRoundResult result = InvasionRound.AttackMarket(playerFleet, target, false);
        if (result == null) {
            memory.set("$exerelinInvasionCancelled", (Object)true, 0.0f);
            return false;
        }
        memory.set("$exerelinInvasionSuccessful", (Object)result.getSuccess(), 0.0f);
        int marinesLost = result.getMarinesLost();
        int marinesRemaining = playerFleet.getCargo().getMarines();
        String attackerStrength = String.format("%.1f", Float.valueOf(result.getAttackerStrength()));
        String defenderStrength = String.format("%.1f", Float.valueOf(result.getDefenderStrength()));
        text.setFontVictor();
        text.setFontSmallInsignia();
        Color hl = Misc.getHighlightColor();
        Color red = Misc.getNegativeHighlightColor();
        text.addParagraph("-----------------------------------------------------------------------------");
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "attackerStrength")) + ": " + attackerStrength);
        text.highlightInLastPara(hl, new String[]{"" + attackerStrength});
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "defenderStrength")) + ": " + defenderStrength);
        text.highlightInLastPara(red, new String[]{"" + defenderStrength});
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "marinesLost")) + ": " + marinesLost);
        text.highlightInLastPara(red, new String[]{"" + marinesLost});
        text.addParagraph(Misc.ucFirst((String)StringHelper.getString(STRING_CATEGORY, "marinesRemaining")) + ": " + marinesRemaining);
        text.highlightInLastPara(hl, new String[]{"" + marinesRemaining});
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
        if (result.getSuccess()) {
            Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.COMBAT_AGGRESSIVE, (Object)0), faction.getId());
        }
        return true;
    }
}

