/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.InteractionDialogImageVisual;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.ShowDefaultVisual;
import com.fs.starfarer.api.util.Misc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExerelinShowDefaultVisual
extends ShowDefaultVisual {
    public static final Map<String, String> CUSTOM_MARKET_IMAGES = new HashMap<String, String>();
    public static final Map<String, String> CUSTOM_MARKET_TAG_IMAGES = new HashMap<String, String>();
    public static final Set<String> CUSTOM_MARKET_TAGS = new HashSet<String>();

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        SectorEntityToken target = dialog.getInteractionTarget();
        String entityId = target.getId();
        if (CUSTOM_MARKET_IMAGES.containsKey(entityId)) {
            dialog.getVisualPanel().showImageVisual(new InteractionDialogImageVisual("illustrations", CUSTOM_MARKET_IMAGES.get(entityId), 640.0f, 400.0f));
        } else if (target.getCustomInteractionDialogImageVisual() != null) {
            dialog.getVisualPanel().showImageVisual(target.getCustomInteractionDialogImageVisual());
        } else if (target instanceof PlanetAPI) {
            dialog.getVisualPanel().showPlanetInfo((SectorEntityToken)((PlanetAPI)target));
        } else if (target instanceof CampaignFleetAPI) {
            CampaignFleetAPI otherFleet;
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            if (playerFleet != (otherFleet = (CampaignFleetAPI)target)) {
                this.showFleetInfo(dialog, playerFleet, otherFleet);
            }
        } else {
            MemoryAPI mem = memoryMap.get("market");
            for (String tag : CUSTOM_MARKET_TAGS) {
                if (!mem.contains(tag) || !CUSTOM_MARKET_TAG_IMAGES.containsKey(tag)) continue;
                dialog.getVisualPanel().showImageVisual(new InteractionDialogImageVisual("illustrations", CUSTOM_MARKET_TAG_IMAGES.get(tag), 640.0f, 400.0f));
            }
        }
        return true;
    }
}

