/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.Wait;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.fleets.ResponseFleetManager;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

public class Exerelin_NotifyInvasion
extends BaseCommandPlugin {
    public static final String RESPONSE_VARIABLE = "$exerelinRespondingToInvasion";
    private EveryFrameScript broadcastScript;
    private EveryFrameScript responseFleetScript;
    private Misc.VarAndMemory waitHandle;

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.waitHandle = params.get(0).getVarNameAndMemory(memoryMap);
        final CampaignFleetAIAPI.ActionType type = CampaignFleetAIAPI.ActionType.HOSTILE;
        final float range = Float.parseFloat(params.get((int)1).string);
        final SectorEntityToken target = dialog.getInteractionTarget();
        final CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        Exerelin_NotifyInvasion.broadcast(type, range, RESPONSE_VARIABLE, (SectorEntityToken)playerFleet, target);
        this.broadcastScript = new EveryFrameScript(){
            private IntervalUtil tracker = new IntervalUtil(0.05f, 0.15f);
            private boolean done = false;

            public boolean runWhilePaused() {
                return false;
            }

            public boolean isDone() {
                return this.done;
            }

            public void advance(float amount) {
                CampaignClockAPI clock = Global.getSector().getClock();
                float days = clock.convertToDays(amount);
                this.tracker.advance(days);
                if (this.tracker.intervalElapsed() && !this.done) {
                    if (((Exerelin_NotifyInvasion)Exerelin_NotifyInvasion.this).waitHandle.memory.contains(((Exerelin_NotifyInvasion)Exerelin_NotifyInvasion.this).waitHandle.name)) {
                        Wait wait = (Wait)((Exerelin_NotifyInvasion)Exerelin_NotifyInvasion.this).waitHandle.memory.get(((Exerelin_NotifyInvasion)Exerelin_NotifyInvasion.this).waitHandle.name);
                        if (wait.getWaitScript().isDone()) {
                            this.done = true;
                            return;
                        }
                    } else {
                        this.done = true;
                        return;
                    }
                    Exerelin_NotifyInvasion.broadcast(type, range, Exerelin_NotifyInvasion.RESPONSE_VARIABLE, (SectorEntityToken)playerFleet, target);
                }
            }
        };
        Global.getSector().addScript(this.broadcastScript);
        this.responseFleetScript = new EveryFrameScript(){
            private boolean done = false;
            private float timeElapsed = 0.0f;
            private final float RESPONSE_DELAY = 0.25f;

            public boolean runWhilePaused() {
                return false;
            }

            public boolean isDone() {
                return this.done;
            }

            public void advance(float amount) {
                float days = Global.getSector().getClock().convertToDays(amount);
                this.timeElapsed += days;
                if (this.timeElapsed >= 0.25f) {
                    CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                    ResponseFleetManager.requestResponseFleet(target.getMarket(), (SectorEntityToken)playerFleet);
                    this.done = true;
                }
            }
        };
        Global.getSector().addScript(this.responseFleetScript);
        return true;
    }

    public static void broadcast(CampaignFleetAIAPI.ActionType type, float range, String responseVariable, SectorEntityToken actor, SectorEntityToken target) {
        Exerelin_NotifyInvasion.broadcast(type, range, responseVariable, actor, target, null);
    }

    public static void broadcast(CampaignFleetAIAPI.ActionType type, float range, String responseVariable, SectorEntityToken actor, SectorEntityToken target, SectorEntityToken exclude) {
        List fleets = target.getContainingLocation().getFleets();
        for (CampaignFleetAPI fleet : fleets) {
            float dist;
            if (fleet == exclude || !(fleet.getAI() instanceof CampaignFleetAIAPI) || !((dist = Misc.getDistance((Vector2f)target.getLocation(), (Vector2f)fleet.getLocation())) <= range)) continue;
            CampaignFleetAIAPI ai = fleet.getAI();
            ai.reportNearbyAction(type, actor, target, responseVariable);
            fleet.getMemoryWithoutUpdate().set("$sawPlayerTransponderOn", (Object)true, 5.0f);
        }
    }
}

