/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.events.SuperweaponEvent;
import exerelin.campaign.fleets.ResponseFleetManager;
import exerelin.utilities.ExerelinUtilsMarket;
import exerelin.utilities.StringHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Exerelin_UseSuperweapon
extends BaseCommandPlugin {
    public static final float STOCKPILE_DESTRUCTION_BASE_MULT = 0.8f;
    public static final float STOCKPILE_DESTRUCTION_SIZE_DIV_MULT = 0.5f;
    public static final float STOCKPILE_DESTRUCTION_VARIANCE = 0.25f;
    public static final int STABILITY_BASE_PENALTY = 7;
    public static final float STABILITY_SIZE_DIVISOR = 3.0f;
    public static final int STABILITY_MAX_SIZE_REDUCTION = 3;
    public static Logger log = Global.getLogger(Exerelin_UseSuperweapon.class);
    public static final Map<String, Float> CR_COSTS = new HashMap<String, Float>();
    protected static final String STRING_CATEGORY = "exerelin_superweapon";

    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        SectorEntityToken target = dialog.getInteractionTarget();
        if (target == null) {
            return false;
        }
        MarketAPI market = target.getMarket();
        if (market == null) {
            return false;
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        FleetMemberAPI bestMember = null;
        float bestCR = 0.0f;
        List members = fleet.getFleetData().getMembersListCopy();
        for (FleetMemberAPI member : members) {
            float cr = member.getRepairTracker().getCR();
            if (cr <= 0.0f) continue;
            if (member.getHullId().equals("ii_boss_olympus")) {
                bestMember = member;
                break;
            }
            if (!member.getHullId().equals("ii_olympus_t") || !(cr > bestCR)) continue;
            bestMember = member;
            bestCR = cr;
        }
        if (bestMember == null) {
            return false;
        }
        String hullId = bestMember.getHullId();
        float crCost = 0.0f;
        if (CR_COSTS.containsKey(hullId)) {
            crCost = CR_COSTS.get(hullId).floatValue();
        }
        if (crCost != 0.0f) {
            if (crCost > bestCR) {
                return false;
            }
            bestMember.getRepairTracker().applyCREvent(-crCost, StringHelper.getString(STRING_CATEGORY, "crText"));
        }
        if (target.getId().equals("tem_ascalon")) {
            memoryMap.get("local").set("$superweaponSuccess", (Object)true, 0.0f);
            Global.getSoundPlayer().playUISound("ii_titan_explode_close", 1.0f, 1.0f);
            return true;
        }
        int size = market.getSize();
        float destructionMult = 0.8f / (0.5f * (float)size);
        ExerelinUtilsMarket.destroyAllCommodityStocks(market, destructionMult, 0.25f);
        int reduction = (int)((float)size / 3.0f);
        if (reduction > 3) {
            reduction = 3;
        }
        int stabilityPenalty = 7 - reduction;
        SectorAPI sector = Global.getSector();
        CampaignEventPlugin eventSuper = sector.getEventManager().getOngoingEvent(new CampaignEventTarget(market), STRING_CATEGORY);
        if (eventSuper == null) {
            eventSuper = sector.getEventManager().startEvent(new CampaignEventTarget(market), STRING_CATEGORY, null);
        }
        SuperweaponEvent event = (SuperweaponEvent)eventSuper;
        event.setStabilityPenalty(stabilityPenalty);
        event.reportSuperweaponUse(fleet);
        ResponseFleetManager.modifyReserveSize(market, -999.0f);
        ExerelinUtilsMarket.refreshMarket(market, true);
        Global.getSoundPlayer().playUISound("ii_titan_explode_close", 1.0f, 1.0f);
        MemoryAPI memMarket = memoryMap.get("market");
        float expire = 180.0f;
        if (memMarket.contains("$playerHostileTimeout")) {
            expire += memMarket.getExpire("$playerHostileTimeout");
        }
        if (expire > 180.0f) {
            expire = 180.0f;
        }
        if (expire > 0.0f) {
            memMarket.set("$playerHostileTimeout", (Object)true, expire);
        }
        TextPanelAPI text = dialog.getTextPanel();
        String destructionStr = String.format("%.0f", Float.valueOf(destructionMult * 100.0f));
        text.addParagraph(StringHelper.getStringAndSubstituteToken(STRING_CATEGORY, "successText", "$market", market.getName()));
        text.setFontVictor();
        text.setFontSmallInsignia();
        text.addParagraph("-----------------------------------------------------------------------------");
        text.addParagraph(StringHelper.getStringAndSubstituteToken(STRING_CATEGORY, "stabilityPenaltyReport", "$stability", Math.abs(stabilityPenalty) + ""));
        text.highlightInLastPara(Misc.getNegativeHighlightColor(), new String[]{stabilityPenalty + ""});
        text.addParagraph(StringHelper.getStringAndSubstituteToken(STRING_CATEGORY, "commodityDestructionReport", "$percent", destructionStr));
        text.highlightInLastPara(Misc.getNegativeHighlightColor(), new String[]{destructionStr});
        text.addParagraph("-----------------------------------------------------------------------------");
        text.setFontInsignia();
        MemoryAPI memLocal = memoryMap.get("local");
        memLocal.set("$superweaponSuccess", (Object)true, 0.0f);
        memLocal.set("$superweaponStabilityPenalty", (Object)stabilityPenalty, 0.0f);
        memLocal.set("$superweaponCommodityDestructionMult", (Object)destructionStr, 0.0f);
        return true;
    }

    static {
        CR_COSTS.put("ii_olympus_t", Float.valueOf(0.4f));
        CR_COSTS.put("ii_boss_olympus", Float.valueOf(0.0f));
    }
}

