/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.utilities.ExerelinConfig;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public abstract class FleetRequestActionBase
extends BaseCommandPlugin {
    protected static final float MARINE_DEFENDER_MULT = 1.25f;

    protected float getMoneyRequiredForFleet(int fp, int numMarines) {
        return (float)numMarines * ExerelinConfig.fleetRequestCostPerMarine + (float)fp * ExerelinConfig.fleetRequestCostPerFP;
    }

    protected MarketAPI getSourceMarketForInvasion(FactionAPI invader, MarketAPI targetMarket) {
        WeightedRandomPicker sourcePicker = new WeightedRandomPicker();
        List markets = Global.getSector().getEconomy().getMarketsCopy();
        Vector2f targetMarketLoc = targetMarket.getLocationInHyperspace();
        for (MarketAPI market : markets) {
            if (market.getFaction() != invader && !market.getFactionId().equals("player_npc")) continue;
            float dist = Misc.getDistance((Vector2f)market.getLocationInHyperspace(), (Vector2f)targetMarketLoc);
            if (dist < 5000.0f) {
                dist = 5000.0f;
            }
            float weight = 20000.0f / dist;
            if (market.hasCondition("military_base")) {
                weight *= 2.0f;
            }
            if (market.hasCondition("orbital_station")) {
                weight *= 1.25f;
            }
            if (market.hasCondition("spaceport")) {
                weight *= 1.5f;
            }
            if (market.hasCondition("headquarters")) {
                weight *= 1.5f;
            }
            if (market.hasCondition("regional_capital")) {
                weight *= 1.25f;
            }
            sourcePicker.add((Object)market, weight *= (float)market.getSize() * market.getStabilityValue());
        }
        MarketAPI originMarket = (MarketAPI)sourcePicker.pick();
        return originMarket;
    }

    protected boolean payForInvasion(int fp, int marines) {
        float moneyRequired = this.getMoneyRequiredForFleet(fp, marines);
        CargoAPI playerCargo = Global.getSector().getPlayerFleet().getCargo();
        if (playerCargo.getCredits().get() >= moneyRequired) {
            playerCargo.getCredits().subtract(moneyRequired);
            return true;
        }
        return false;
    }
}

