/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.FleetRequestActionBase;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.campaign.events.InvasionFleetEvent;
import exerelin.campaign.fleets.InvasionFleetManager;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FleetRequestFire
extends FleetRequestActionBase {
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        if (dialog == null) {
            return false;
        }
        SectorAPI sector = Global.getSector();
        SectorEntityToken target = dialog.getInteractionTarget();
        MarketAPI targetMarket = target.getMarket();
        if (targetMarket == null) {
            return false;
        }
        FactionAPI fleetFaction = sector.getFaction(PlayerFactionStore.getPlayerFactionId());
        MarketAPI sourceMarket = this.getSourceMarketForInvasion(fleetFaction, targetMarket);
        if (targetMarket.getFactionId().equals("player_npc")) {
            sourceMarket = targetMarket;
            fleetFaction = sector.getFaction("player_npc");
        } else if (targetMarket.getFaction() == fleetFaction) {
            sourceMarket = targetMarket;
        }
        MemoryAPI memory = memoryMap.get("local");
        int fp = (int)memory.getFloat("$fleetRequestFP");
        int marines = (int)memory.getFloat("$fleetRequestMarines");
        this.payForInvasion(fp, marines);
        boolean isInvasionFleet = marines > 0;
        boolean isDefenceFleet = !targetMarket.getFaction().isHostileTo(fleetFaction);
        String fleetType = "exerelinInvasionSupportFleet";
        if (isInvasionFleet) {
            fleetType = "exerelinInvasionFleet";
        } else if (isDefenceFleet) {
            fleetType = "exerelinDefenceFleet";
        }
        InvasionFleetManager.FleetSpawnParams fleetParams = new InvasionFleetManager.FleetSpawnParams();
        fleetParams.name = InvasionFleetManager.getFleetName(fleetType, fleetFaction.getId(), fp);
        fleetParams.fleetType = fleetType;
        fleetParams.faction = fleetFaction;
        fleetParams.fp = fp;
        fleetParams.originMarket = sourceMarket;
        fleetParams.targetMarket = targetMarket;
        fleetParams.numMarines = marines;
        fleetParams.noWander = true;
        fleetParams.noWait = true;
        InvasionFleetManager.InvasionFleetData data = InvasionFleetManager.spawnFleet(fleetParams);
        TextPanelAPI text = dialog.getTextPanel();
        Color hl = Misc.getHighlightColor();
        LocationAPI originLoc = sourceMarket.getPrimaryEntity().getContainingLocation();
        String origin = originLoc.getName();
        String sourceMarketName = sourceMarket.getName();
        if (!originLoc.isHyperspace()) {
            origin = " " + origin;
        }
        String message = "";
        if (sourceMarket == targetMarket) {
            message = StringHelper.getStringAndSubstituteToken("exerelin_fleets", "fleetSpawnMessageLocal", "$market", sourceMarketName);
        } else {
            message = StringHelper.getString("exerelin_fleets", "fleetSpawnMessage");
            message = StringHelper.substituteToken(message, "$market", sourceMarketName);
            message = StringHelper.substituteToken(message, "$location", origin);
        }
        text.addParagraph(message);
        text.highlightInLastPara(hl, new String[]{sourceMarketName, origin});
        if (isInvasionFleet) {
            InvasionFleetEvent event;
            SectorManager.createWarmongerEvent(targetMarket.getFactionId(), target);
            CoreReputationPlugin.RepActionEnvelope envelope = new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.COMBAT_NORMAL, null, dialog.getTextPanel());
            Global.getSector().adjustPlayerReputation((Object)envelope, targetMarket.getFactionId());
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("target", targetMarket);
            eventParams.put("dp", Float.valueOf(data.startingFleetPoints));
            data.event = event = (InvasionFleetEvent)Global.getSector().getEventManager().startEvent(new CampaignEventTarget(sourceMarket), "exerelin_invasion_fleet", eventParams);
            event.reportStart();
        }
        return true;
    }
}

