/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.alliances.Alliance;
import exerelin.utilities.StringHelper;
import java.util.List;
import java.util.Map;

public class JoinAlliance
extends BaseCommandPlugin {
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String str;
        if (dialog == null) {
            return false;
        }
        String playerFactionId = PlayerFactionStore.getPlayerFactionId();
        if (!playerFactionId.equals("player_npc")) {
            return false;
        }
        Alliance oldAlliance = AllianceManager.getFactionAlliance(playerFactionId);
        String newAllianceId = params.get(0).getString(memoryMap);
        Alliance newAlliance = AllianceManager.getAllianceByUUID(newAllianceId);
        boolean oldAllianceDissolved = false;
        TextPanelAPI text = dialog.getTextPanel();
        AllianceManager.setPlayerInteractionTarget(dialog.getInteractionTarget());
        if (oldAlliance != null && oldAlliance != newAlliance) {
            AllianceManager.leaveAlliance(playerFactionId, false);
            oldAllianceDissolved = oldAlliance.getMembersCopy().size() <= 1;
            str = StringHelper.getString("exerelin_alliances", "switchedAlliances");
            str = StringHelper.substituteToken(str, "$OldAlliance", oldAlliance.getName());
        } else {
            str = StringHelper.getString("exerelin_alliances", "joinedAlliance");
        }
        if (oldAlliance != newAlliance) {
            AllianceManager.joinAllianceStatic(playerFactionId, newAlliance);
        }
        AllianceManager.setPlayerInteractionTarget(null);
        MemoryAPI memory = memoryMap.get("player");
        AllianceManager.setMemoryKeys(memory, newAlliance);
        str = StringHelper.substituteToken(str, "$NewAlliance", newAlliance.getName());
        text.addParagraph(str, Misc.getPositiveHighlightColor());
        if (oldAllianceDissolved) {
            str = StringHelper.getString("exerelin_alliances", "allianceDissolved");
            str = StringHelper.substituteToken(str, "$OldAlliance", oldAlliance.getName());
            text.addParagraph(str, Misc.getHighlightColor());
        }
        return true;
    }
}

